% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahn_gen.R
\name{ahn_gen}
\alias{ahn_gen}
\title{Generate networks characterising habitat physical configurations}
\usage{
ahn_gen(N, L, mu, lamda, Connected = TRUE, Weighted = TRUE, eta = 1,
  A = 25, X = NULL, Y = NULL, U = NULL, V = NULL)
}
\arguments{
\item{N}{The number of nodes}

\item{L}{A side length of the rectangle landscape within which nodes are anchored}

\item{mu}{the critical \code{Dij} (i.e. Euclidean distance between node \code{i} and \code{j}) at which the link removing probability curve \code{P(Dij, mu, lamda)} transits from concave to convex (see \code{\link{ahn_prob}})}

\item{lamda}{the steepness of the link removing probability curve \code{P(Dij, mu, lamda)}, see \code{\link{ahn_prob}}}

\item{Connected}{\code{TRUE} for connected while \code{FALSE} ignores whether the networks are connected or not}

\item{Weighted}{\code{TRUE} for weighted while \code{FALSE} for unweighted networks}

\item{eta}{mediates the weight, i.e. \code{(Dij)^-eta}, of the link rewiring node \code{i} from one network component and node \code{j} from another network component (\code{i} and \code{j} are with an Euclidean distance of \code{Dij}) when the network becomes disconnected after removing links from the initial complete network with the probability \code{P(Dij, mu, lamda) = [1 + exp(-lamda(Dij - mu))]^-1} when both \code{Connected = TRUE} and \code{Weighted = TRUE}}

\item{A}{The area of the rectangle landscape within which the network is defined}

\item{X}{A vector of \code{X} coordinates for the \code{N} nodes (sampled from \code{[0, L]} uniformly at random if \code{NULL})}

\item{Y}{A vector of \code{Y} coordinates for the \code{N} nodes (sampled from \code{[0, A/L]} uniformly at random if \code{NULL})}

\item{U}{A vector with \code{N} elements specifying node attributes (qualitative or quantitive), by default \code{NULL}}

\item{V}{A vector with \code{N} elements specifying node attributes (qualitative or quantitive), by default \code{NULL}}
}
\value{
Return an animal habitat network (an \code{igraph} object)
}
\description{
Generate undirected networks (weighted or unweighted, connected or disconnected) characterising the physical attributes and spatial organizations (or distributions) of habitat components (i.e. habitat configurations).
}
\examples{
# generate a connected and weighted network
ahn_gen(N = 10, L = 5, mu = 1, lamda = 5)

\donttest{

N <- 10
x <- runif(N, 0, 5)
ql <- sample(LETTERS, N, replace = TRUE)
qn <- sample(1:20, N, replace = TRUE)

# specify the X coordinates, node attributes U and V for a connected and unweighted network
ahn_gen(N, L = 5, mu = 1, lamda = 5, Weighted = FALSE, X = x, U = ql, V = qn)

# specify the Y coordinates, node attributes U and V for a weighted network, no matter if the
# network will be connected or not
ahn_gen(N, L = 5, mu = 1, lamda = 5, Weighted = TRUE, Connected = FALSE, Y = x, U = ql, V = qn)

}

}
