% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_coclustering.R
\name{AM_coclustering}
\alias{AM_coclustering}
\title{Return the co-clustering matrix}
\usage{
AM_coclustering(fit)
}
\arguments{
\item{fit}{an \code{\link{AM_mcmc_output}} object.}
}
\value{
A numeric co-clustering matrix
}
\description{
Given an \code{\link{AM_mcmc_output}} object, this function returns the co-clustering matrix.
}
\details{
The co-clustering matrix is produced by the simultaneous clustering of the rows and columns. Each entry denotes the (posterior) probability
that items \eqn{i} and \eqn{j} are together.  This technique is also known as
bi-clustering and block clustering \insertCite{govaert2013co}{AntMAN}, and is useful for understanding the number of clusters in the dataset.
}
\examples{
\donttest{
fit = AM_demo_uvp_poi()$fit
ccm <- AM_coclustering(fit)
}
}
\seealso{
\code{\link{AM_clustering}}
}
