% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpspike-functions.R
\name{expcov_gpSpike}
\alias{expcov_gpSpike}
\title{Covariance kernel with squared-exponential and unit nugget for \code{gpSpike()}}
\usage{
expcov_gpSpike(vec, invlambda)
}
\arguments{
\item{vec}{Numeric vector of input locations. \eqn{t = X'\theta} is the main input value for the single-index model.}

\item{invlambda}{Non-negative numeric scalar scaling the kernel amplitude.
Larger values increase both diagonal and off-diagonal
entries proportionally.}
}
\value{
A numeric \eqn{n \times n} covariance matrix with entries \eqn{K_{ij} = \lambda^{-1}\,\exp\{-(\mathrm{t}_i - \mathrm{t}_j)^2\}}
for \eqn{i \ne j}, and \eqn{K_{ii} = \lambda^{-1} + 1} where \eqn{i, j = 1, \cdots, n}.
}
\description{
A \pkg{nimble} function that constructs a covariance matrix on the \eqn{t = X'\theta}
using a squared–exponential Gaussian kernel scaled by
\eqn{\lambda^{-1}}, with an added unit nugget on the diagonal.
Covariance matrix is \eqn{I + K_{ij}} where \eqn{K_{ij} = \lambda^{-1}\exp\{-(\mathrm{t}_i - \mathrm{t}_j)^2\}} for \eqn{i, j = 1, \cdots, n}.
}
\details{
The off-diagonal structure follows the squared–exponential kernel, producing
rapidly decaying correlations as the squared distance grows. The matrix is
filled in a symmetric manner and then a unit nugget \eqn{I} is added to
the diagonal. The parameter \code{invlambda} controls the overall signal
scale of the kernel component. If a different nugget is desired, adjust externally.
}
\seealso{
\code{\link{gpSpike}}, \code{\link{predict.bsimGp}}
}
