% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdDiag_scalar_hdf5}
\alias{bdDiag_scalar_hdf5}
\title{Apply Scalar Operations to Diagonal Elements}
\usage{
bdDiag_scalar_hdf5(
  filename,
  group,
  dataset,
  scalar,
  operation,
  target = NULL,
  paral = NULL,
  threads = NULL,
  outgroup = NULL,
  outdataset = NULL,
  overwrite = NULL
)
}
\arguments{
\item{filename}{String. Path to the HDF5 file containing the dataset.}

\item{group}{String. Group path containing the input dataset.}

\item{dataset}{String. Name of the input dataset (matrix or vector).}

\item{scalar}{Numeric. Scalar value for the operation.}

\item{operation}{String. Operation to perform: "add", "subtract", "multiply", "divide".}

\item{target}{Optional string. Where to write result: "input" or "new" (default: "new").}

\item{paral}{Optional logical. Whether to use parallel processing (default: FALSE).}

\item{threads}{Optional integer. Number of threads for parallel processing.}

\item{outgroup}{Optional string. Output group path (only used if target="new").}

\item{outdataset}{Optional string. Output dataset name (only used if target="new").}

\item{overwrite}{Optional logical. Whether to overwrite existing datasets (default: FALSE).}
}
\value{
List with components:
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{gr}{Character string with the HDF5 group}
\item{ds}{Character string with the full dataset path (group/dataset)}
}
}
\description{
Performs optimized scalar operations on diagonal elements of matrices or vectors
stored in HDF5 format. Automatically detects whether input is a matrix (extracts
diagonal) or vector (direct operation) and applies the specified scalar operation.
}
\details{
This function provides flexible scalar operations on diagonals:
\itemize{
\item Supported operations:
\itemize{
\item "+": diagonal[i] + scalar
\item "-": diagonal[i] - scalar
\item "*": diagonal[i] * scalar
\item "/": diagonal[i] / scalar
\item "pow": diagonal[i] ^ scalar
}
\item Input types:
\itemize{
\item Matrix input: Extracts diagonal automatically
\item Vector input: Operates directly (most efficient)
}
\item Target options:
\itemize{
\item "input": Modifies original dataset in-place
\item "new": Creates new dataset with result
}
}
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create test matrix
A <- matrix(rnorm(100), 10, 10)
bdCreate_hdf5_matrix("test.h5", A, "data", "matrix_A", overwriteFile = TRUE)

# Add scalar to diagonal (creates new dataset)
result <- bdDiag_scalar_hdf5("test.h5", "data", "matrix_A",
                            scalar = 5.0, operation = "+",
                            target = "new", outdataset = "diag_plus_5")

# Multiply diagonal in-place
result2 <- bdDiag_scalar_hdf5("test.h5", "data", "matrix_A", 
                             scalar = 2.0, operation = "*",
                             target = "input")
}

}
