% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_shares.R
\name{species_shares}
\alias{species_shares}
\title{species_shares}
\usage{
species_shares(
  x,
  tree_filter = TRUE,
  method = c("ba_wd", "ba", "n"),
  include_ingrowth = TRUE
)
}
\arguments{
\item{x}{An \code{\link{fe_stand}} object}

\item{tree_filter}{A \code{data-masking} expression that applies to the
data.frame \code{x$trees}. It must return a logical value, and is defined
in terms of the variables in \code{x$trees}. In this function, it is used
internally in order to define the cohort of trees which is to be evaluated
by this function (within a call to \code{dplyr::filter()}). While many
meaningful filterings are conceivable, distinctions between total stand,
removal stand, and remaining stand are the most probable applications.
Defaults to \code{TRUE}, i.e. all trees are included. See examples.}

\item{method}{Character string defining the calculation method to be applied.
Must be one of "ba_wd" (default), "ba", and "n" (see Details).}

\item{include_ingrowth}{If \code{TRUE} (default), newly ingrown trees will be
included in the calculation.}
}
\value{
A data frame (tibble) with the three columns \code{species_id},
\code{time_yr}, and \code{species_share}. If no tree passes the
user-defined \code{tree_filter}, the tibble will have no lines.
}
\description{
Calculate tree species shares for a \code{\link{fe_stand}} object. Different
methods and scopes are available.
}
\details{
The calculation uses the \code{trees} data frame of the input
\code{\link{fe_stand}} object. The small tree cohort is not taken into
account. Three different methods are available to choose from (parameter
\code{method}: \describe{ \item{\bold{Basal area shares, weighted with wood
density (method "ba_wd"): }}{ The species shares are based on basal areas
which are weighted with the species specific wood densities raised to the
power of 2/3. The exponent of 2/3 takes into account that wood density is a
three-dimensional quantity, while basal area is two-dimensional. This is the
default method. It works, however, only with species codings that can be
converted into the \code{\link{fe_species_tum_wwk_short}} coding (default),
or with \code{\link{fe_species_bavrn_state_short}}. The latter is used if
this species coding is directly provided or if the species coding is
\code{\link{fe_species_bavrn_state}}. The reason for that restriction is that
wood densities are currently only provided for the two species codings
\code{\link{fe_species_tum_wwk_short}}, and
\code{\link{fe_species_bavrn_state_short}}. The resulting shares, however,
will always relate to the original coding.} \item{\bold{Unweighted basal area
shares (method "ba"):}}{ Species shares are calculated as shares of the
unweighted basal areas. } \item{\bold{Stem number shares (method "n"):}}{
Species shares are calculated as stem number shares, i.e. tree size does not
matter for that calculation. } }
}
\examples{
species_shares(selection_forest_1_fe_stand) # default method ("ba_wd")
species_shares(selection_forest_1_fe_stand, method = "ba")
species_shares(selection_forest_1_fe_stand, method = "n")

# Same stand, different cohorts
mm_forest_1_fe_stand_spatial |> species_shares() # all trees
mm_forest_1_fe_stand_spatial |> species_shares(!removal) # remaining only
mm_forest_1_fe_stand_spatial |> species_shares(removal) # removal only

}
