% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_obesity.R
\name{simulate_obesity}
\alias{simulate_obesity}
\title{Simulate obesity status}
\usage{
simulate_obesity(
  x,
  obes_prev = "OBESITY_CrudePrev",
  obes_sd = "OBESITY_SD",
  obes_label = "FIPS",
  n = 1000
)
}
\arguments{
\item{x}{data frame containing obesity data as a percentage from 0 to 100.}

\item{obes_prev}{column name of prevalence.}

\item{obes_sd}{column name of standard deviation.}

\item{obes_label}{column name of labeling term, required if \code{x} has more than
one row.}

\item{n}{simulated sample size.}
}
\value{
List of arrays containing simulated obesity status.
}
\description{
Simulate obesity status
}
\examples{
# Input has default column names
df <- data.frame(OBESITY_CrudePrev = c(20, 50, 80),
                 OBESITY_SD = c(5, 5, 5),
                 FIPS = letters[1:3])
simulate_obesity(df, n = 5)

# Input has custom column names
df <- data.frame(prev = c(20, 50, 80),
                 sd = c(5, 5, 5),
                 label = letters[1:3])
simulate_obesity(df,
                 obes_prev = "prev",
                 obes_sd = "sd",
                 obes_label = "label",
                 n = 5)

}
