% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdfSteps.r
\name{ecdfSteps}
\alias{ecdfSteps}
\title{ecdfSteps}
\usage{
ecdfSteps(x, extend)
}
\arguments{
\item{x}{numeric vector, possibly with \code{NA}s that are ignored}

\item{extend}{a 2-vector do extend the range of x (low, high).  Set \code{extend=FALSE} to not extend \code{x}, or leave it missing to extend it 1/20th of the observed range on other side.}
}
\value{
a list with components \code{x} and \code{y}
}
\description{
Compute Coordinates of an Empirical Distribution Function
}
\details{
For a numeric vector uses the R built-in \code{ecdf} function to compute
coordinates of the ECDF, with extension slightly below and above the
range of \code{x} by default.  This is useful for \code{ggplot2} where the ECDF may need to be transformed.  The returned object is suitable for creating stratified statistics using \code{data.table} and other methods.
}
\examples{
ecdfSteps(0:10)
\dontrun{
# Use data.table for obtaining ECDFs by country and region
w <- d[, ecdfSteps(z, extend=c(1,11)), by=.(country, region)]  # d is a DT
# Use ggplot2 to make one graph with multiple regions' ECDFs
# and use faceting for countries
ggplot(w, aes(x, y, color=region)) + geom_step() +
       facet_wrap(~ country)
}
}
\seealso{
\code{\link[stats:ecdf]{stats::ecdf()}}
}
\author{
Frank Harrell
}
