\name{USStates}
\alias{USStates}
\docType{data}
\title{US State Data}
\description{
Various data for all 50 US States.
}
\format{
  A data frame with 50 observations on the following 22 variables.
  \describe{
    \item{\code{State}}{State name}
    \item{\code{HouseholdIncome}}{Median household income (in $1,000's)}
    \item{\code{Region}}{\code{MW}=Midwest, \code{NE}=Northeast, \code{S}=South, \code{W}=West}
    \item{\code{Population}}{Number of residents (in millions for 2014)}
    \item{\code{EighthGradeMath}}{Average score NAEP mathematics for 8th-grade students }
    \item{\code{HighSchool}}{\% of residents (ages 25-34) who are high school graduates}
    \item{\code{College}}{\% of residents (ages 25-34) who are college graduates }
    \item{\code{IQ}}{Estimated mean IQ score of residents}
    \item{\code{GSP}}{Gross state product (in $1,000's per capita)}
    \item{\code{Vegetables}}{\% of residents eating vegetables at least once per day }
    \item{\code{Fruit}}{\% of residents eating fruit at least once per day}
    \item{\code{Smokers}}{\% of residents who smoke}
    \item{\code{PhysicalActivity}}{\% who do 150+ minutes of aerobic physical activity per week}
    \item{\code{Obese}}{\% obese residents (BMI 30+)}
    \item{\code{NonWhite}}{\% nonwhite residents }
    \item{\code{HeavyDrinkers}}{\% heavy drinkers ( men: 14+ drinks/week, women 7+ drinks/week)}
    \item{\code{Electoral}}{Number of state votes in the presidential electoral college}
    \item{\code{ClintonVote}}{Proportion of votes for Democrat Clinton in 2016 presidential election}
    \item{\code{Elect2016}}{State winner in 2016 presidential election (\code{D}=Clinton, \code{R}=Trump)}
    \item{\code{TwoParents}}{\% of children living in two-parent households}
    \item{\code{StudentSpending}}{School spending (in $1,000 per pupil) }
    \item{\code{Insured}}{\% of adults (ages 19-64) who have any kind of health coverage}
  }
}
\details{
Information from each of the 50 states of the United States.  Years vary from 2013 to 2018 depending on data availability. \cr
** Updated for 3e  (earlier versions are now USStates2e and USStates1e) **

}
\source{
U.S. Census Bureau, 2013-2017 5-Year American Community Survey \cr

\url{http://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_17_5YR_DP03&src=pt} \cr

\url{http://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_17_5YR_S1501&src=pt} \cr

\url{http://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_17_5YR_B02001&prodType=table} \cr

\url{http://factfinder.census.gov/faces/nav/jsf/pages/index.xhtml} (Table C23008) \cr

\url{https://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_17_5YR_S2701&prodType=table}
}
\keyword{datasets}
