<!-- NEWS.md was auto-generated by NEWS.Rmd. Please DO NOT edit by hand!-->

# Changes in version 1.1.1 (2025-09-11)

## New functions

- `correct_PMTLinearity()`: A helper function to correct luminescence
  signals measured with a PMT for count linearity (#920).

## Removed functions and deprecations

- Functions `calc_Kars2008()` (defunct since 0.9.26),
  `Analyse_SAR.OSLdata()` (since 1.0.0), `PSL2Risoe.BINfileData()`
  (since 1.0.0) and `Second2Gray()` (since 1.0.0) have been removed from
  the package. Their functionality can be found in functions
  `calc_Huntley2006()`, `analyse_SAR.CWOSL()`,
  `convert_PSL2Risoe.BINfileData()` and `convert_Second2Gray()`,
  respectively.

- Function `get_Risoe.BINfileData()` has been removed as it was not used
  and provided no benefits to the user (#945).

## Bugfixes and changes

## `add_metadata<-()`

- The function throws an error if trying to assign a `NULL` value
  instead of silently ignoring it (#946).

### `analyse_Al2O3C_ITC()`

- The function returns early if the fitting of the dose response curve
  fails (#979).

### `analyse_Al2O3C_Measurement()`

- The function allows to specify the `cross_talk_argument` as a numeric
  vector of length 3, as was already documented (#930).

### `analyse_SAR.CWOSL()`

- The function crashed if any of the curves had `NA` as its `recordType`
  (#867).

### `apply_CosmicRayRemoval()`

- The `method` argument of `smooth_RLum()` was not reachable via `...`
  as the `apply_CosmicRayRemoval()` already has an argument called
  `method`. Now the `...` argument is called `method_smooth_RLum` and
  works as expected (9b27467).

- The function crashed if method = “Pych”`and`MARGIN = 1\` were
  specified. The function now better validates its inputs and no longer
  returns invisibly but normally (#987).

### `calc_AliquotSize()`

- The legend text now scales better at non-default cex settings (#849).

### `calc_Huntley2006()`

- If the user set the `n.MC` argument, this was also used in the fitting
  of the dose response curve. This was not the expected behaviour, and
  resulted in poor performance (a 2x slowdown for `n.MC = 10000`). This
  regression was introduced in version 1.0.0 (#867).

### `calc_MaxDose()`

- The function crashed if `sigmab` was set to a very small value (#898).

### `calc_MinDose()`

- The function crashed when bootstrapping with `bs.M = 1`. Now the
  `bs.M` parameter is silently reset to 2 in that case, although such
  low values are discouraged as they may trigger a warning during loess
  fitting (#900).

- The function crashed when all rows in the input data set contained
  `NA` values (#915).

### `calc_Statistics()`

- The computation of the weighted median is now correct, while before it
  corresponded to the simple (unweighted) median (#905).

### `fit_CWCurve()`

- The function hanged on particularly small datasets as it tried to fit
  too many components for the available data (#953).

### `fit_DoseResponseCurve()`

- The object returned now contains an additional `.De.raw` column to
  store the calculated De value computed by the fitting function “as
  is”, without setting meaningless results to `NA`. The `De` and
  `.De.raw` columns differ only for `mode = "interpolation"`, where the
  first sets the De to `NA` if negative, while the latter doesn’t. It is
  then up to the user to decide what to do with those values, bearing in
  mind that they may be arbitrary when negative (#957).

- The message reported for `fit.method = "QDR"` now states correctly
  whether the fit succeeded or failed (#961).

- The computation of De.MC, De.Error and HPDI for
  `mode = "interpolation"` has been modified to account correctly for
  possible negative De values resulting from the fit (#963).

- Previously, a single `NA`value in the Monte Carlo results prevented
  the computation of Highest Density Intervals (HPDI). This limitation
  has been removed, and now HPDIs are reported in more cases (#976).

- The columns of the `results$De` data frame are now reported in a
  different order; an additional “Mode” column reports the value of the
  `mode` argument; columns meant for internal use have been moved to the
  end and their names are now prefixed with `.` (#974).

### `fit_LMCurve()`

- The automatic correction of the x-axis limits when `log = "x"` is
  specified and the lowest value is set to `0` threw the correct warning
  but actually did nothing (38e4324).

### `fit_OSLLifeTimes()`

- The function ensures that the `signal_range` argument doesn’t contain
  negative values instead of crashing (#896).

### `get_RLum()`

- The function doesn’t crash anymore on `RLum.Analysis` objects if using
  the `record.id` argument removes all available records (#873).

- An internal optimization increased the performance of the function.
  The difference is not perceivable on single calls to `get_RLum()`, but
  the change brings a visible speed up when `merge_RLum()` is called
  over a sufficiently large number of `RLum.Analysis` objects (#875).

### `merge_Risoe.BINfileData()`

- The function gained argument `verbose` to allow disabling the output
  from `read_BIN2R()` and `write_R2BIN()` (#950).

### `plot_AbanicoPlot()`

- The positioning of the y-axis label has been improved to be centred
  around the zero line (#847). The z-axis tickmarks and labels are
  better drawn at non-default cex values (#865).

- The minor grid lines were drawn incorrectly in a rotated plot (#849).

- Some plot elements didn’t scale correctly at non-default cex values
  (#861, \#879).

- The `frame` argument is now respected also when the plot is rotated
  (#863).

- The weighted median is computed correctly when `summary = "median"`
  and `summary.method = "weighted"` are used (#905).

### `plot_DoseResponseCurve()`

- We added support for the `log` graphical parameter, which can be used
  if the fit was obtained with mode other than `"extrapolation"` (#820).

- The normal curve drawn as part of the histogram plot could appear very
  jagged or even as a straight line, as it could happen that too few
  points were actually used when drawing the curve (#843).

- The legend symbols did not match anymore the plotted regeneration/dose
  points. This also affected functions such as `analyse_SAR.CWOSL()` and
  `analyse_pIRIRSequence()` (9ba54e65).

- The legend positioning can now be controlled via the `...` argument
  `legend.pos` (#959).

### `plot_DRCSummary()`

- The dose-response curve is now plotted as expected, after a regression
  in 1.1.0 caused the function to produce an empty plot (#969).

### `plot_DRTResults()`

- Points didn’t scale correctly at non-default `cex` values (#879).

- Option `summary = "weighted$median"` is now officially supported
  (#905).

### `plot_Histogram()`

- Option `summary = "median.weighted"` is now officially supported
  (#905).

### `plot_KDE()`

- Outlier points didn’t scale correctly at non-default `cex` values
  (#879).

- The weighted median is computed correctly when `summary = "median"`
  and `summary.method = "weighted"` are used (#905).

### `plot_RadialPlot()`

- Option `summary = "median.weighted"` is now officially supported
  (#905).

### `plot_Risoe.BINfileData()`

- Input arguments are validate more strictly to avoid unexpected crashes
  in case of misspecification (#964).

- The x-axis label for TL curves now reports temperature rather than
  time, consistently with the data shown (#971).

### `plot_RLum.Analysis()`

- The legend text now scales better at non-default `cex` settings
  (#854).

### `plot_RLum.Data.Curve()`

- The function gained a new logical argument `interactive` that enables
  interactive plotting of curves using `plotly::plot_ly()`. It requires
  the suggested package `'plotly'` to be installed (e4746eaa).

### `plot_RLum.Data.Spectrum()`

- Types `image` and `contour` gained more control of the contour line
  labels through the argument `labcex`.

- For plot types `"image"` and `"multiple.lines"` the `...` logical
  argument `legend` was added.

- Plot type `"image"` further gained a legend with support through `...`
  for `legend.pos`, `legend.horiz` and `n_breaks` to control the number
  of colours in the graphic.

### `read_BIN2R()`

- The `FNAME` metadata field is no longer left empty if the BIN-file
  didn’t specify one, but it’s populated with the BIN-file name without
  extension. This is the behaviour that was present up to version
  0.9.26, but version 1.0.0 had regressed it (#928).

### `read_XSYG2R()`

- Add support for the new function `correct_PMTLinearity()` (#920).

### `smooth_RLum()`

- Add support for the Poisson smoother of Carter et al. (2018), which
  can be accessed by setting `method = "Carter_etal_2018"`. This is
  helpful to ensure that the dark-background counts signals measured by
  a photomultiplier tube follow a Poisson statistic, and smooths
  non-conforming values according to an average over four neighbours
  (#921).

### `trim_RLum.Data()`

- The function crashed if both values specified in the `trim_range`
  argument exceeded the number of channels available (#871).

### `use_DRAC()`

- Report the message produced by the DRAC server more reliably in case
  of error (#982).

------------------------------------------------------------------------

# Changes in version 1.1.0 (2025-06-11)

## New functions

- `remove_SignalBackground()`: A user-friendly method to subtract
  background signals from various curves in `RLum.Analysis` objects
  without resorting to `lapply()` loops. Depending on the record type,
  the function identifies pairs of curves; for instance, if in a
  sequence, a `TL` curve is immediately followed by another `TL` curve,
  the second curve is recognised as the background signal, subtracted
  using `merge_RLum()` and subsequently removed from the object (if
  desired). Alternatively, a set of potential background curves can be
  specified.

- `remove_RLum()`: This function further completes the set of methods
  that can handle and modify `RLum-class` objects. It operates on
  `RLum.Analysis` objects or a `list` of such objects to remove unwanted
  records from datasets. Although the function calls `get_RLum()` and
  relies on its functionality, the new implementation facilitates a more
  logical workflow and analysis pipeline.

- `.as.latex.table()`: Converts `RLum.Results` objects where suitable to
  `LaTeX` ready tables, for instance, objects produced by `use_DRAC()`.
  The function has been present in the package as an internal function
  for many years; now it is exported and better linked to make it
  discoverable.

## New datasets

- `RF70Curves` is a new dataset consisting of two IR-RF curves measured
  with the RF70 protocol. This new dataset provides a more realistic
  example for `analyse_IRSAR.RF()`.

## Breaking changes

- Function `get_Quote()` is no longer exported, but remains available as
  an internal function. This is unlikely to affect any user of the
  package, as the function was only meant to report a random quote at
  startup (#644).

- In the functions `fit_DoseResponseCurve()` and `plot_GrowthCurve()`,
  the `fit.method` option `LambertW` was replaced by the more correct
  term `OTOR`.

- Argument `cex.global` has been removed from `plot_DoseResponseCurve()`
  (and consequently also from `plot_GrowthCurve()`), and if set it will
  be silently ignored. Users can set the `cex` graphical parameter via
  `...` in its place (#831).

- The `fit.method` and `fit.advanced` arguments of function
  `fit_LMCurve()` have been removed. The default fitting method has been
  changed from `port` to `LM`, and support for the `port` algorithm has
  been removed. From now on, argument `fit.method` is silently ignored,
  unless `fit.method = 'port'` is used, in which case a deprecation
  warning is thrown (#793).

- The fundamental physical constants used in the package (such as
  Boltzmann constant, Planck constant, etc.) have been uniformed to
  those reported in the [NIST Reference on Constants, Units and
  Uncertainty](https://physics.nist.gov/cuu/Constants/). This may affect
  the numerical results of the following functions: `calc_FastRatio()`,
  `calc_Huntley2006()`, `calc_SourceDoseRate()`,
  `calc_ThermalLifetime()`, `convert_Activity2Concentration()`,
  `convert_Wavelength2Energy()`, `fit_CWCurve()`, `fit_LMCurve()`,
  `fit_SurfaceExposure()`, `fit_ThermalQuenching()` (#693).

## Bugfixes and changes

### `analyse_baSAR()`

- The function crashed if only one aliquot was kept (#834).

### `analyse_FadingMeasurement()`

- The function crashed if the number of `Lx` and `Tx` curves was not
  equal when `structure = c("Lx", "Tx")`, which is the default. The
  check that the number of points within each pair of curves has also
  been improved, and the function now produces more helpful error
  messages (#616).

- The function tests are now less rigorous for different `Lx` and `Tx`
  sizes. While they should match, numerical rounding issues in the data
  returned by the measurement devices could previously result in
  rejection of records, although this had no actual meaning for the data
  analysis.

### `analyse_IRSAR.RF()`

- The legend and subtitle texts now scale better at non-default cex
  settings (#803).

- The printing of progress bars and messages to the terminal can now be
  controlled via the `...` argument `verbose`. Previously this could
  only be done via the `txtProgressBar` argument (which is still
  supported), but the new option makes the interface consistent with
  most other functions (#805).

- The `mtext` and `cex` options are respected if `method = "None"`
  (#807).

- The residual plot correctly respects the logarithmic transformation of
  the x-axis when `log = "x"` or `log = "xy"` are specified (#814,
  \#825).

- The function now deals correctly also with input objects containing
  multiple curves (#816).

- The residual indicator rectangle, which is drawn when `method` is
  either `SLIDE` or `VSLIDE`, is also drawn when `log = "x"` (#821).

- The plotting of the density is silently disabled if `n.MC = NULL`,
  which avoids a spurious warning (#823).

### `analyse_pIRIRSequence()`

- The function now respects the `cex` graphical argument, and its plot
  output has been subtly improved thanks to various fixes that have
  occurred especially in `plot_DoseResponseCurve()` (#831).

### `analyse_portableOSL()`

- The function now returns an error if `mode` is something other than
  `"profile"` or `"surface"`.

- The `mode` argument was not respected when operating over a list of
  objects (#673).

- The function crashed when using `mode = "surface"` if the plotting
  limits were too tight and left only one point (#675).

- The check on the validity of the `signal.integral` argument has been
  improved, and now it occurs only once, so at most one warning is
  raised if the argument is set to a value exceeding the valid range
  (#678, \#680).

- The function returns a clearer message when no x-coordinates were
  measured and `mode = "surface"` was used (#682).

- The `cex` and `type` graphical parameters can now configured via the
  `...` argument (#684).

- The expected sequence pattern of the input object is validated more
  thoroughly to avoid crashes in case of misspecification (#687).

- The graphical `...` argument `contour` never produced a meaningful
  contour plot due to an internal error (#686). Along, arguments
  `contour_nlevels` and `contour_col` are now supported through `...` to
  better control the number and colour of contour lines.

### `analyse_SAR.CWOSL()`

- Add support for `fit.method = 'OTORX'` following the changes in
  `fit_DoseResponseCurve()`; this change includes the new argument
  `dose.points.test` that is only of use in combination with the `OTORX`
  fit.

- Add new graphical output if the measurements were single grain
  measurements, in such case a disc with the position and grain number
  marked in shown. This plot replaces the IRSL curve check plot, but
  only for single grain data (#797).

- The rejection criteria plot was rewritten and now provides an easier
  to grasp visual feedback (#797, \#798).

- The `IRSL`/`Single Grain` panel swapped place with the rejection
  criteria panel; the plot numbers remained unchanged to avoid
  regression.

- More code optimisation for better readability (#802)

### `analyse_SAR.TL()`

- A check on the `sequence.structure` argument ensures that a “SIGNAL”
  entry has been specified (#779).

### `calc_AliquotSize()`

- The new argument `sample_carrier.diameter` allows to specify a value
  for the diameter of the sample carrier, which up to now was hardcoded
  to the very common 9.8 mm size (#623).

- Several graphical parameters can now configured via `...` arguments,
  so that the plot appearance can be fully customized (#671).

### `calc_AverageDose()`

- A bug in the implementation prevented the default plot settings from
  being modified via `...` as advertised. Now custom settings are
  respected (#658).

### `calc_FiniteMixture()`

- The function doesn’t crash anymore if the `n.components` argument
  specifies non-consecutive values (#691).

- The function sometimes failed to plot some of the densities when the
  number of components was set to a value of 8 or more (#704).

- The density plots would not always be coloured completely, but
  especially for high values of `sigmab` there would be an unfilled area
  at the base of the densities (#706).

- If the very first iteration over the components during plotting was
  skipped, then the function crashed as a quantity computed only in that
  iteration was not available. This happened for very specific
  combinations of `sigmab` and `n.components` (#708).

- Another crash occurred when height of the largest density curve could
  not be estimated due to the presence of too many `NA` values in the
  intermediate computations (#710).

- The check for significance of each component added to the model has
  been corrected to be more statistically rigorous (#703).

- Blank gaps appearing to the sides of the proportion of components plot
  for high number of components have been removed (#713), as well as
  extra slices appearing due to rounding errors (#715).

- The plot can be better configured via the new `plot.criteria` argument
  to control whether the statistical criteria curves should be drawn.
  Moreover, support for the `...` options has been added: `cex` to
  control the overall scaling, `main.densities`, `main.proportions` and
  `main.criteria` to set the subplot titles (#717).

- Plots are now generated even when results contain `NA` values, as they
  in general don’t affect the plot. However, when that happens we report
  it in the plot subtitle (#718).

### `calc_Huntley2006()`

- Support was added for multicore computations via the `cores` argument,
  and for the nls-fitting control options `maxiter` and `trace`.

- The fitting of the simulated curve with the GOK model has been made
  more robust: when an initial fit of the model fails, the fit is
  attempted again with 10 different values for `D0` and the best fit is
  used. This should reduce the number of occasions in which the error
  message “Could not fit simulated model curve, check suitability of
  model and parameters” is reported (#660).

- The function crashed if all simulated Lx/Tx values were identical and
  approximately zero, which could happen if the `rhop` argument was set
  to a large enough value (#725).

- An error message has been improved so that it doesn’t suggest setting
  the ‘fit.bounds = FALSE’ argument if it has already been set (#729).

- The computation of the x-axis limits has been improved to avoid having
  too much unused horizontal space, especially for
  `mode = "extrapolation"` (#731).

- The scaling of the plot can now be controlled via the `cex` argument
  (#735).

- The plot margins are set more precisely and avoid the summary text to
  be cut off (#737).

### `calc_MinDose()`

- The function now warns if the number of bootstrap replicates is too
  low to perform the loess fitting (#721).

### `calc_OSLLxTxRatio()`

- The function returned a warning for wrong integral settings for the
  `Tx` curve even if no `Tx` curve was provided.

- The function does not check any more of different object types for
  `Lx.data` and `Tx.data` but validate objects for allowed types (this
  should have no user-visible effects).

### `convert_Concentration2DoseRate()`

- The function validates its input values more thoroughly (#613).

### `extract_IrradiationTimes()`

- The function tries a little bit harder to extract the correct duration
  of TL steps, rendering the data output hopefully a little bit more
  intelligible (#651).

- The function gained a new argument called `return_same_as_input`, with
  default value of `FALSE`. If set to `TRUE`, the input object (usually
  an `RLum.Analysis` object or a `list` of them) is returned with
  updated info elements for `IRR_TIME` and `TIMESINCEIRR`. This makes
  the `RLum.Analysis` object compatible with functions that explicitly
  search for those two objects, such as those in the
  `'OSLdecomposition'` package (#752).

### `fit_DoseResponseCurve()`

- The function now allocates less memory for storing intermediate values
  (#610).

- Add initial support for `OTORX` fitting following Lawless and
  Timar-Gabor 2024 (#677). The code implementation follows the Python
  reference by [jll2](https://github.com/jll2/LumDRC/blob/main/otorx.py)
  with an addition for an allowed offset parameter `a` set if
  `fit.force_through_origin = FALSE`. This also enables to support
  `mode = "extrapolation"` (thanks to John Lawless for his input).

- The code of the function was optimised in several places to improve
  code readability and reduce redundant calls.

- The models for `EXP`, `EXP+LIN`, `EXP+EXP` and `GOK` are now available
  in C++. This cut the required computation times in half in benchmark
  scenarios. More importantly, this performance scales with the number
  of Monte Carlo runs.

### `fit_EmissionSpectra()`

- Fix crash when attempting to plot a frame with non-positive counts
  (#761).

### `fit_LMCurve()`

- If the user asks logarithmic scaling in the y-axis, using either
  `log = "y"` or `log = "xy"`, this is now ignored when plotting
  residuals and component contributions (#755).

- The plot has been slightly reworked to reduce the cases of “margin too
  large” errors and to work better at high settings of `cex` (#757).

- Missing values in the input data are now silently removed (#759,
  \#763).

- The plotting of residuals, component contributions and legend can now
  be disabled, and the legend position can be controlled (#785).

- The error computed when using option `fit.calcError = TRUE` is now
  returned correctly, instead of being left to `NA` (#789).

- Argument `bg.subtraction` also accepts the option `"none"` to disable
  background subtraction even if `values.bg` is provided (#795).

### `fit_SurfaceExposure()`

- It is now possible to specify different values for the light
  attenuation coefficient `mu` when a list of input data is provided
  (#667).

### `fit_ThermalQuenching()`

- The `trace` option, which can be specified via the `method_control`
  argument, is now respected.

- The model now get internally reformulated into a mathematically
  equivalent expression that is easier to fit. This should reduce the
  number of occasions when the function fails to find a valid solution
  and improve the uncertainty estimation (#696).

### `get_RLum()`

- The argument `subset` can now be provided as a character that
  represents a logical expression. Before, it always required a logical
  expression, but this may lead to odd effects due to the early
  evaluation happening in R and might not be wanted. Providing `subset`
  as a character is now a viable workaround in those situations.

### `import_Data()`

- The function uses the most common formats (BINX and XSYG) before
  trying all others.

### `merge_RLum.Data.Curve()`

- The function does no longer stops for differing channel resolutions,
  but it does issue a warning. The user is responsible for the
  consequences.

### `plot_DetPlot()`

- The logic for multicore support was incorrect, which resulted in
  always starting a parallel cluster even when `multicore = FALSE`
  (#742).

### `plot_DoseResponseCurve()`

- The response curve always tries to the get the 0 point in the mode
  `interpolation` and `alternate` (#677).

- Minor graphical polish to limit overplotting and also plot a density
  curve for the `L_n/T_n` signal.

- If `mode = "alternate"`, the message that the equivalent dose could
  not be fitted is no longer shown.

- Argument `cex.global` has been removed and will be silently ignored
  (#831).

### `plot_DRCSummary()`

- Add support for `fit.method = 'OTORX'` following the change in
  `fit_DoseResponseCurve()` (#677).

### `plot_DRTResults()`

- The summary and legend texts now scale better at non-default cex
  settings (#765).

- Argument `given.dose` is better validated against misspecifications,
  and setting it to 0 is equivalent to leaving it at its default `NULL`
  value, which corresponds to avoiding data normalization (#767, \#799).

- The function crashed when multiple inputs were used with
  `boxplot = TRUE` and all preheat values were identical (#769).

- Plot title, summary text and legend are now better positioned (#773,
  \#774, \#781).

- A bug in the way colours and symbols are assigned to plot points has
  been fixed (#777).

- The horizontal axis doesn’t include anymore a spurious extra tick that
  didn’t correspond to any aliquot (#783).

### `plot_GrowthCurve()`

- Add support for `fit.method = 'OTORX'` following the change in
  `fit_DoseResponseCurve()` (#677).

- Argument `cex.global` has been removed and will be silently ignored
  (#831).

### `plot_Histogram()`

- The function now doesn’t produce warnings when the input consists of a
  single-column data frame, as it assumes that the De error is 10^-9
  (#744).

- The right margin is now smaller when errors are not plotted, as there
  is no need to leave space for the standard error axis (#748).

- The summary text now scales better at non-default cex settings (#750).

### `plot_KDE()`

- The function validates its input values more thoroughly (#635).

- Setting `summary.pos` to one of “left”, “center” or “right” resulted
  in the summary table not being visible (#642).

- Argument `output` has been removed, and it will be ignored if set
  (#700).

### `plot_RadialPlot()`

- The function validates its input values more thoroughly (#639).

- The legend text now scales better at non-default cex settings (#746).

### `plot_RLum.Data.Curve()`

- We added comprehensive support for base R plotting arguments utilised
  by `plot.default()` and `par()`. This enhancement ensures that all
  available arguments are fully supported (#646).

- The function gained a new logical argument named `auto_scale`. When
  set in conjunction with either `xlim` or `ylim`, this argument
  automatically adjusts the plot range to align with the corresponding
  settings for `xlim` or `ylim`. For instance, if a user intends to plot
  OSL curves but initially selects the `xlim` range `c(10:30)` to
  examine the background, the initial count values may be excessively
  large, resulting in limited visibility. With the introduction of the
  `auto_scale` option, the `ylim` values are automatically adjusted to
  compensate for this scenario. The `auto_scale` argument is also
  accessible through `plot_RLum.Analysis()` and `plot_RLum()` (#646).

### `plot_RLum.Data.Spectrum()`

- The channel-wise background subtraction was essentially broken if a
  background spectrum with the same setting was provided. The function
  always calculated the arithmetic mean. This was fixed, and the manual
  updated accordingly.

- If a background spectrum was provided, the behaviour of the plot
  output was sometimes hard to understand without knowledge of the
  underlying code. This behaviour was improved and now `ylim` will also
  affect the background spectrum if `bg.channels = NULL` (the default).

- The function could crash if column names were missing and the
  1bg.spectrum\` argument was used (#726).

### `read_TIFF2R()`

- The argument `file` can now be provided as a `list` or a character
  vector.

- The function gained a new logical argument called `merge2stack` that
  can be used if `file` is either a `list` or a character vector of
  length \> 1. If set to `TRUE`, images are combined into one image
  stack.

### `read_XSYG2R()`

- A redundant computation has been removed, and the function is now
  marginally faster on files where the detector is not a spectrometer
  (#753).

- Prepare import for an updated version of LexStudio2 (\>=v2.31.1) where
  the horizontal hardware binning finally works after \>10 years, but
  the changes introduce a lot of `NaN` values that would cause a crash
  of the function.

- Minor code refactoring for a small speed boost if spectrometer
  measurements are imported.

### `scale_GammaDose()`

- Argument `plot_singlePanels` now works as documented, that is it
  produces all plots in a single page when set to `FALSE` (default), and
  one plot per page when set to `TRUE` (#698).

### `sort_RLum()`

- The sorting mechanism for `RLum.Analysis` objects has been enhanced.
  It now enables sorting based on multiple parameters, including sorting
  all available `info_elements` in a prioritised manner (#606, \#620).

- Sorting now works on a list of `RLum.Analysis` objects. If the list
  contains elements of a different type, they are passed through
  unchanged. The output is again a list (#620).

### `structure_RLum()`

- The function now returns a less messy data frame because it
  encapsulates `.pid` and `info` as lists within the data frame. The
  function is primarily used internally to facilitate a rapid
  exploration of `RLum.Analysis` object structures. However, the change
  may potentially break existing code in extremely rare circumstances.

### `template_DRAC()`

- The function now throws messages instead of warnings for wanted
  coercions; however, it will be hard on failed coercions that would
  cause `use_DRAC()` to fail.

### `use_DRAC()`

- The function now checks for DRAC specific URL parts if a custom URL is
  provided; this avoids long searches for unspecific errors.

- Due to the internal masking of submitted values, the initial row order
  got mixed up; regression from \#438. The order is maintained and the
  row index corrected; in other words, the masking should now be again
  invisible to the user.

### `verify_SingleGrainData()`

- The function crashed if an object originating from `read_XSYG2R()`
  contained positions in its `info` field (#740).

### `write_R2TIFF()`

- The function now supports the export of more than one image slice.

## Internals

- The internal function `create_UID()` has undergone further
  optimisation for speed, resulting in a significant performance
  improvement. Additionally, it now generates a hash value with a
  consistent length instead of a time stamp with a random number.

------------------------------------------------------------------------

# Changes in version 1.0.1 (2025-03-07)

## Bugfixes

### `analyse_baSAR()`

- The number of aliquots used was only partially reported if no aliquots
  were removed, resulting in an incomplete message in the output to the
  terminal.

### `analyse_FadingMeasurement()`

- The function now checks that an input object generated from an XSYG
  file contains irradiation steps and returns an error if none are
  available, instead of producing an unhelpful output (#588).

- A regression in `plot_RLum.Analysis()` caused part of the plot of the
  luminescence curves to be garbled (#589).

- The function crashed on a file generated by `read_XSYG2R()` if the
  number of curves available after removal of the irradiation step was
  not enough for the the fading measurement to be analysed (#603).

### `analyse_pIRIRSequence()`

- The check on the minimum device plot size used to fail if only one
  dimension was below our minimum threshold, and when it was incorrectly
  triggered by the floating point values computed by
  `grDevices::dev.size()`, which sometimes could be spuriously just
  below threshold. We also changed the minimum device size from 18 to 16
  inches (#593).

### `calc_CosmicDoseRate()`

- The function crashed if the number of depths provided exceeded that of
  the densities and the latter contained more than one value (#595).

### `calc_FadingCorr()`

- The function sporadically returned an implausibly large error estimate
  if any of the Monte Carlo simulations produced an outlier solution
  (#597).

- The function now allocates only as much memory as required if the user
  specifies a value for `n.MC` other than `"auto"`, which brings a small
  speed-up if fewer than 10 million samples are requested.

- Input arguments are now more thoroughly checked to avoid warnings or
  unhelpful messages (#599).

### `calc_FastRatio()`

- The function crashed if the input was an RLum.Analysis object (#586).

### `plot_AbanicoPlot()`

- The `xlim`, `ylim` and `zlim` parameters are now better validated to
  avoid possible crashes if misspecified (#581).

### `plot_RLum.Analysis()`

- The function reset incorrectly the graphical parameters for the case
  `plot_singlePanels = TRUE`. This caused a regression in the plot
  output from `analyse_FadingMeasurement()` (#589).

### `sort_RLum()`

- The function doesn’t crash when multiple fields are specified,
  although the actual sort at the moment occurs only on the first field
  (#606).

- Attempting to sort an empty object returns the object itself instead
  of crashing (#608).

------------------------------------------------------------------------

# Changes in version 1.0.0 (2025-02-21)

## New functions

- `apply_Crosstalk()`, `calc_MoransI()`, `plot_SingleGrainDisc()` and
  `plot_MoranScatterplot()` were contributed by Anna-Maartje de Boer and
  Luc Steinbuch (#560). An introductory example on how to use these
  functions is available by executing `vignette("crosstalk")`.

- `calc_EED_Model()` models incomplete and heterogeneous bleaching of
  mobile grains after Guibert et al. (2017). Along with the function,
  the new `ExampleData.MortarData` data set was added.

- `fit_DoseResponseCurve()` and `plot_DoseResponseCurve()` are two new
  functions derived from `plot_GrowthCurve()`: the first only performs
  the fitting of a dose-response curve, while the second plots it. This
  brings greater flexibility and increased speed, as plotting is now
  independent of fitting (#141).

- `melt_RLum()`: Creates a new flat `data.frame` that can be used for
  instance in combination with `'ggplot2'`. It works only on
  `RLum.Data.Curve-class` and `RLum.Analysis-class` objects and lists of
  such objects.

- `merge_RLum.Data.Spectrum()`: This new function allows to merge two or
  more `RLum.Data.Spectrum` objects in different ways (#368).

- `add_metadata()`, `rename_metadata()`, `replace_metadata()`: These
  function allow to manipulate the metadata of `Risoe.BINfileData`,
  `RLum.Analysis` and `RLum.Data` objects (#480, fixed in \#514, \#524,
  \#525, \#527, \#534, \#545).

- `sort_RLum()`: Allows to sort the records of `RLum.Analysis` and
  `Risoe.BINfileData` objects according to a given slot or info element
  (#528).

- `view()`: Provides a shortcut to the `utils::View()` spreadsheet-like
  data viewer tailored to the objects in the package (#489).

## Breaking changes

- We have dropped our dependency on the `readxl` package: functions
  `analyse_baSAR()` and `use_DRAC()` now do not accept XLS files anymore
  but CSV files instead (#237). CSV files can be easily generated from
  XLS files by Excel or similar applications, or by reading them with
  `readxl::read_excel()` and saving them with `write.csv()`.

- The `plot.single` option, which was available for several functions,
  sometimes under a slightly different name, has now been renamed to
  `plot_singlePanels` for overall consistency and clarity. Function
  `scale_GammaDose()` used that option but gave it the opposite meaning:
  now also this function conforms to the rest of the package. The use of
  the older names is now deprecated and will produce a warning (#351).

- The `NumberIterations.MC` option of `plot_GrowthCurve()` has now been
  renamed to `n.MC` for consistency with other functions. Potentially
  affected are also `analyse_Al2O3C_ITC()`, `analyse_baSAR()`,
  `analyse_SAR.CWOSL()`, `analyse_SAR.TL()`, `calc_Huntley2006()`,
  `calc_Lamothe2003()`, as they may pass that option
  `plot_GrowthCurve()` via their `...` argument. The use of the older
  name is now deprecated and will produce a warning (#546).

## Renamed functions and deprecations

- Function `Analyse_SAR.OSLdata()` is now officially deprecated,
  `analyse_SAR.CWOSL()` should be used instead (#216).

- Functions `CW2pHMi()`, `CW2pLM()`, `CW2pLMi()` and `CW2pPMi()` have
  been renamed to `convert_CW2pHMi()`, `convert_CW2pLM()`,
  `convert_CW2pLMi()` and `convert_CW2pPMi()`, respectively. The use of
  the older names is now deprecated and will produce a warning (#499).

- Function `Second2Gray()` has been renamed to `convert_Second2Gray()`
  (#498).

- Function `PSL2Risoe.BINfileData()` has been renamed to
  `convert_PSL2Risoe.BINfileData()` (#555).

## New dependencies

- We have added package `’vdiffr’` as dependency in `suggests`. The
  package enables us to automatically verify the consistency of plot
  outputs generated by package functions against reference figures
  captured earlier. Although this new dependency does not have any
  user-visible impact, it is required when building `’Luminescence’`
  from source. The primary advantage lies in the developer’s domain, as
  it ensures that modifications to functions do not inadvertently alter
  plot outputs.

## Bugfixes

### `analyse_Al2O3C_CrossTalk()`

- The function doesn’t crash anymore if option `recordType` is specified
  and none of the records in the data set is of that type (#487).

### `analyse_baSAR()`

- Argument `XLS_file` has been replaced by `CSV_file` and, as mentioned
  above, the function now only accepts CSV files as input (#237).
- Add support for `recordType` passed to `get_RLum` in the additional
  arguments.
- Option `plot.single` has been renamed to `plot_singlePanels` (#351).
- The function crashed if the number of MCMC iterations was set equal to
  the thinning interval; on the other hand, we saw errors reported from
  JAGS if the number of MCMC iterations was not at least double the
  thinning interval. To address this, we slightly retouched our
  automatic setting of the thinning interval (which was problematic only
  if the number of MCMC iterations was extremely low); on the other
  hand, if a user sets a thinning interval that is too high, we now
  reset it to a lower value and raise a warning (#407).
- The function crashed if a `Risoe.BINFileData` object was provided and
  the argument `irradiation_times` was set; fixed.
- The function was supposed to remove non-OSL curves from the dataset,
  but it almost never did; fixed.
- The function is more robust against input that may have been subset
  inconsistently (#517).
- The function doesn’t crash but reports more helpful messages in case
  the user overrides the default set of monitored variables using
  `variable.names` within the `method_control` argument (#521).

### `analyse_SAR.CWOSL()`

- The function crashed for a list input that led to `NULL` for various
  reasons (e.g., unsuitable set of curves). Here the self-call attempted
  to extract information from the results that did not exist in the
  first place instead of returning `NULL`; fixed.
- The produced `RLum.Results` object now also contains a column for the
  grain (#553).

### `analyse_FadingMeasurement()`

- The function now checks for the version of the BIN-file that
  originated the `RLum.Analysis` object given as input, and reports a
  message if a version older than 5 was used (#281).
- The function doesn’t crash anymore on some `RLum.Analysis` input files
  (#283).
- Option `plot.single` has been renamed to `plot_singlePanels` (#351).
- The function doesn’t crash anymore if no record is left after removal
  of records with negative time since irradiation (#454).
- The function has been made more robust in the calculation of rho’
  (#558).

### `analyse_IRSAR.RF()`

- The performance of this function has been improved for the “SLIDE” and
  “VSLIDE” methods, thanks both to tweaks in the C++ implementation of
  the sliding algorithm and in how that is managed on the R side. In
  particular, the default number of sliding windows tested in the
  algorithm has been reduced from 10 to 3: this value is no longer
  hardcoded, but can be tuned through the new `num_slide_windows`
  setting (part of the `method.control` option), thus allowing to find a
  balance between computation time and quality of fit (#372).
- The function is more robust against `sequence_structure`
  misspecifications (#393).
- Some data preparation steps where not correctly applied for
  `method = "VSLIDE"` (#396).
- Option `method.control` has been renamed to `method_control` for
  consistency with all other functions in the package (#411).

### `analyse_pIRIRSequence()`

- Option `plot.single` has been renamed to `plot_singlePanels` (#351,
  fixed in \#408).
- The produced `RLum.Results` object now also contains a column for the
  grain (#553).
- The function now checks that the `sequence.structure` argument
  contains at least one IR step (#579).

### `analyse_SAR.CWOSL()`

- Option `plot.single` has been renamed to `plot_singlePanels` (#351).
- The function shifted the curves correctly in cases where the first
  channel is zero and a log-transformation on the x-axis is requested
  (#580).

### `apply_CosmicRayRamoval()`

- Support has been added for the internal function `smooth_RLum` that
  can be passed as new argument for `method`.

### `calc_AverageDose()`

- The function crashed if the data contained non-positive values: now
  these are removed before proceeding (#532).

### `calc_CentralDose()`

- Argument `na.rm` is now deprecated: the function will now always
  remove missing values, as otherwise the presence of any `NA` would
  propagate and produce unusable results (all `NA`s) or buggy behaviour
  (#302).
- The function stops the fixed-point iteration for the computation of
  the profile log-likelihood as soon as `sigma < 1e-16`, as allowing
  `sigma` to become zero leads to infinities and buggy behaviour (#304).

### `calc_FastRatio()`

- A number of crashes related to input validation have been fixed
  (#471).

### `calc_FiniteMixture()`

- Arguments `dose.scale` and `pdf.scale` were not used and have been
  removed (#566).

### `calc_gSGC()`

- The function crashed if the data contained negative errors: to avoid
  this, we now take the absolute values of errors (#479).

### `calc_Huntley2006()`

- Some crashes in case of model misspecification have been solved
  (#538).
- Some details in the implementation of the function have been
  optimized, and now it is much faster than before. As part of this, we
  have changed the default setting of the `rprime` vector that is used
  in the calculation of the natural dose response and the field
  saturation, so that more points are concentrated in the bulk of the
  distribution: this previously depended incorrectly on the number of
  Monte Carlo iterations requested, so this change brings an additional
  speed boost. The default setting can be overridden via the `rprime`
  argument (#258).
- Fitting the “GOK” model on the unfaded data failed when the “EXP”
  model we use to find a good starting point failed: in such cases, we
  try again using the simulated fit (#549; thanks to @SalOehl for
  reporting and providing data to reproduce the error).
- The natural/simulated curve was not plotted in the negative quadrant
  for `mode = "extrapolation"`, which made it harder to see where it
  extrapolated to (#551; thanks to @SalOehl for reporting).

### `calc_IEU()`

- The code of this function has been consolidated to avoid duplication
  and make its debugging easier: this has uncovered a small coding error
  and also led to some speed up (#429).
- Some crashes in the function have been solved (#424).

### `calc_Lamothe2003()`

- We addressed a long-standing issue regarding the calculation of the
  `Ln/Tn` error after fading correction, which led to smaller than
  expected errors (#96).

### `convert_RLum2Risoe.BINFileData()`

- The function could crash with a
  `incompatible types (from raw to character)` error under particular
  circumstances; fixed.
- The function would fail in edge cases where different objects are
  mixed so that certain fields for `METADATA` are already available but
  in the wrong format; fixed.

### `extract_IrradiationTimes()`

- In some circumstances the function failed to update an existing
  BIN/BINX file due to an incorrect way of subsetting an intermediate
  data frame of results (#445).
- The function crashed if the info element `startDate` was missing in
  the irradiation curve; fixed.

### `fit_CWCurve()`

- The function crashed if the computation of the confidence intervals
  done in `confint()` failed. This has now been fixed, and in cases of
  failures we report the error message received from `confint()` (#509).
- Argument `output.terminal` has been renamed to `verbose` for
  consistency with other functions.
- The function has gained the new `method_control` argument, which can
  be used to control the saving of the component contribution matrix in
  the RLum.Results object it returns. This is now disabled by default:
  to restore the previous behaviour, add
  `method_control = list(export.comp.contrib.matrix = TRUE)` to the
  function call (#573).
- In case of plot failure the function now is able to recover gracefully
  and produce an output object (#574).

### `fit_EmissionSpectra()`

- The function can now return a data frame with the values of all curves
  plotted, so that it’s much easier to produce alternative plots, by
  setting option `export.plot.data = TRUE` within the `method_control`
  argument (#569).

### `fit_LMCurve()`

- The function has gained the new `method_control` argument, which can
  be used to control the saving of the component contribution matrix in
  the RLum.Results object it returns. This is now disabled by default:
  to restore the previous behaviour, add
  `method_control = list(export.comp.contrib.matrix = TRUE)` to the
  function call (#573).
- In case of plot failure the function now is able to recover gracefully
  and produce an output object (#574; thanks to @LumTKO for reporting).

### `get_RLum()`

- If the `subset` option was used on info elements of an `RLum.Analysis`
  object, it would return wrong results if the info element was not
  present in all records; fixed.

### `import_Data()`

- The function automatically determines the available import functions
  and ensures that formats supported by the package are tested and used.
- A minor change in the code enables the support of `character` vectors
  of length \> 1 as input (e.g., different file names). Furthermore, the
  function received more testing against a mixture of input formats.
  Therefore you can provide many different files formats and the
  function will try to import them all in one go.

### `plot_AbanicoPlot()`

- If negative values were provided, the function sometimes produced
  wrong plots for `z.log = TRUE` (the default); fixed.
- Support for `tcl` and `tck` arguments via `...` was removed as they
  were never used internally.

### `plot_DetPlot()`

- Option `plot.single` has been renamed to `plot_singlePanels` (#351,
  fixed in \#408).

### `plot_DRTResults()`

- The function crashed if option `na.rm` was used alongside the
  `preheat` option but the data set contained no missing values (#474).

### `plot_GrowthCurve()`

- The function is now implemented as a wrapper around
  `fit_DoseResponseCurve()` and `plot_DoseResponseCurve()`. There should
  be no visible user-facing changes (#319).
- Support new `...` arguments for plotting (implementation in
  `plot_DoseResponseCurve()`) for `legend` (turn on/off legend) and
  `reg_points_pch` for fine grained control over the point shape.
- Add `density_polygon`, `density_polygon_col`, `density_rug`, `box` as
  `...` arguments to plot and add respective plot options
- The function crashed for single grain data that sometimes caused a lot
  of `NaN` values during log conversions required for estimating the
  start parameters. The result was the error `object 'b.MC' not found`
  (#374; fixed)
- For the non-linear choices of `fit.method` (`"EXP+LIN"`, `"EXP+EXP"`,
  `"GOK"` and `"LambertW"`), the function could get stuck in an endless
  loop when the number of parameters was larger than or equal to the
  number of data points. This is now checked, and in those cases the
  method is changed to `"LIN"` (#381).
- We replaced `nls()` with `minpack.lm::nlsLM()` as it’s more robust and
  can find a fit in cases where `nls()` would fail. Please keep in mind
  that it does not mean that fit results in those cases make any sense,
  it just helps to avoid uncontained events in the R session (addresses
  \#381).
- Option `output.plotExtended.single` has been renamed to
  `plot_singlePanels` (#351).
- The function now supports a list of data frames as input, in which
  case it calls itself on each element of the list and produces a list
  of `RLum.Results` as output (#405).
- The function reported negative dose values in the MC runs plot when
  using `fit.method = "QDR"` and `mode = "extrapolation"` (#504).
- Argument `NumberIterations.MC` has been renamed to `n.MC` (#546).

### `plot_RLum.Analysis()`

- Option `plot.single` has been renamed to `plot_singlePanels` (#351).

### `plot_RLum.Data.Curve()`

- Argument `norm` is now better validated so that specifying an
  incorrect value returns an error instead of silently skipping curve
  normalisation (#250).

### `plot_RLum.Data.Spectrum()`

- The gradient between colours when `plot.type = "persp"` is now more
  consistent and doesn’t produce artefacts in the regions of transition
  between colours (#371).
- The function would crash if the `bin.rows` or `bin.cols` value was set
  too high or if `xlim` and `ylim` were set too tight (#415).

### `read_BIN2R()`

- The function is now much faster: we have recorded an overall
  improvement of over 60% on a 46M file, with potentially bigger time
  savings for larger files (#298).
- Argument `n.records` is now better supported for BIN files v3 and v4
  and doesn’t lead to a crash when used in conjunction with the
  `fastForward` option (#343).
- Argument `zero_data.rm` was not correctly propagated if the input
  object was provided as a list (#342).
- The `METADATA` fields that are not actually read from the BINX file in
  case of a ROI record are now set to `NA` rather than being assigned
  the value from the previous record (#336).
- The `.RESERVED` slot is now kept in sync with the rest of the object
  when records are dropped from the input BIN/BINX file (#337).
- The function doesn’t crash anymore when reading a file that contains a
  record with an unrecognised version after other records with a valid
  version have been read (#352).
- The function doesn’t crash anymore when reading a file that contains a
  ROI record while using `fastForward = TRUE` (#356).

### `read_HeliosOSL2R()`

- If the function encounters problems in the provided list of files, it
  shows a more relaxed handling; throws an error but continues reading.

### `read_XSYG2R()`

- The new `n_records` argument now enables to control the number of
  records to import, which can be useful in case the file is faulty.
- The function failed to import files when a directory name was
  provided; this was a regression introduced in v0.9.25 and it has now
  been fixed.
- The function truncated the terminal output under certain
  circumstances; fixed.

### `scale_GammaDose()`

- Option `plot_single` has been renamed to `plot_singlePanels` and was
  changed so that `plot_singlePanels = TRUE` will produce one plot per
  panel, for consistency with other functions (#351).

### `template_DRAC()`

- The function gained a new argument `file_input` that enables the
  creating of a DRAC template based on an existing DRAC CSV file. This
  way, already available DRAC files can be conveniently modified without
  having to call `use_DRAC()` first.
- The template contained a couple of minor mistakes that got fixed along
  with a more strict enforcement of the class of each field, which is
  now set as an attribute; the change should have no user-visible
  effect.
- The function now supports the conversion factors by Cresswell et
  al. (2018) (`Cresswelletal2018`). Please ensure that the server
  supports that option.

### `trim_RLum.Data()`

- The function has been made more robust against misspecifications of
  its `trim_range` argument that could lead to crashes (#460).

### `use_DRAC()`

- Support for DRAC v1.1 XLS/XLSX files has been dropped, users should
  use CSV files according to the DRAC v1.2 CSV template.
- The function gained support for three new `...` arguments:
  `version_ignore` to ignore the DRAC version check, `user` and
  `password` to access password protected websites.
- The identifiers submitted to the DRAC server are now better randomized
  to to guarantee more confidentiality of the data transmitted (#435).

### `verify_SingleGrainData()`

- **Potentially breaking old code!**: if `cleanup = TRUE` the result was
  not consistent and produced a mixture of `RLum.Results` and
  `RLum.Analysis`/`Risoe.BINFileData` objects in particular when run
  over a list, this was not what stated in the manual. Now the function
  indeed cleans up the object, hence if a list of `RLum.Analysis`
  objects is provided, the result is a cleaned list of that object. If
  the clean-up ends up removing everything, the result is `NULL`.
- The function doesn’t crash anymore when applied to an empty list
  (#365).
- Silence the very talkative terminal output even if nothing was removed
  from a record for `cleanup = TRUE`.
- The function now provides better terminal feedback if the selection
  results in an empty record.
- Add a new logical argument `use_fft` that will apply an additional
  Fast Discrete Fourier Transform (FFT) verification on the data if
  wanted.

### `write_R2BIN()`

- The function now supports the `verbose` argument, which can be used to
  suppress output to the terminal (#442).
