% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_portableOSL.R
\name{analyse_portableOSL}
\alias{analyse_portableOSL}
\title{Analyse portable CW-OSL measurements}
\usage{
analyse_portableOSL(
  object,
  signal.integral = NULL,
  invert = FALSE,
  normalise = FALSE,
  mode = "profile",
  coord = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} (\strong{required}):
object produced by \link{read_PSL2R}. The input can be a \link{list} of such objects,
in which case each input is treated as a separate sample and the results
are merged.}

\item{signal.integral}{\link{numeric} (\strong{required}):
A vector specifying the range of channels used to calculate the OSL/IRSL
signal. It can be provided as a vector of length 2 such as \code{c(1, 5)}, or
as a sequence such as \code{1:5}, in which case the lowest and highest values
define the range.}

\item{invert}{\link{logical} (\emph{with default}): \code{TRUE} flip the plot the data in reverse order.}

\item{normalise}{\link{logical} (\emph{with default}):
whether the OSL/IRSL signals should be normalised to the \emph{mean} of all
corresponding data curves.}

\item{mode}{\link{character} (\emph{with default}):
analysis mode, one of \code{"profile"} (the default) or \code{"surface"} for surface
interpolation.}

\item{coord}{\link{list} \link{matrix} (\emph{optional}): a list or a 2-column matrix
with the \emph{x} and \emph{y} coordinates for the sampling positions in meters (m),
of the same length as the number of samples measured. For example, the
coordinates for one sample could be \verb{coord = list(samp1 = c(0.1, 0.2)}.
If the \emph{x} coordinates were not measured, \emph{x} should be set to 0.
Note that, in such case, a surface plot cannot be produced.}

\item{plot}{\link{logical} (\emph{with default}): enable/disable the plot output.}

\item{...}{other parameters to be passed to modify the plot output.
Supported are \code{run} to provide the run name (if the input is a \code{list}, this
is set automatically). Further plot parameters accepted are \code{main},
\code{col}, \code{xlim} (a named \link{list} for profile mode), \code{ylim}, \code{ylab}, \code{xlab}.
Additional parameters for \code{mode = "profile"} are  \code{type}, \code{pch}, \code{grid}
(\code{TRUE}/\code{FALSE}), \code{bg_img} (a raster object for the background image,
usually a profile photo), \code{bg_img_positions} (a vector with the four corner
positions, see \link[graphics:rasterImage]{graphics::rasterImage}), \code{zlab} (here x-axis labelling).
Additional parameters for \code{mode = "surface"} are \code{surface_value}
(\link{character} with names of the surfaces to plot), \code{col_ramp}, \code{legend}
(\code{TRUE}/\code{FALSE}), \code{contour} (\code{TRUE}/\code{FALSE}),\verb{ }contour_nlevels\verb{, }contour_col\verb{, ' zlim}.}
}
\value{
Returns an S4 \linkS4class{RLum.Results} object with the following elements:

\verb{$data}\cr
\code{.. $summary}: \link{data.frame} with the results\cr
\code{.. $data}: \link{list} with the \linkS4class{RLum.Analysis} objects\cr
\code{.. $args}: \link{list} the input arguments
}
\description{
The function analyses CW-OSL curve data produced by a SUERC portable OSL reader and
produces a combined plot of OSL/IRSL signal intensities, OSL/IRSL depletion ratios
and the IRSL/OSL ratio.
}
\details{
This function only works with \linkS4class{RLum.Analysis} objects produced by \link{read_PSL2R}.
It further assumes (or rather requires) an equal amount of OSL and IRSL curves that
are pairwise combined for calculating the IRSL/OSL ratio.
For calculating the depletion ratios, the cumulative signal of the last \emph{n}
channels (same number of channels as specified by \code{signal.integral}) is
divided by cumulative signal of the first \emph{n} channels (\code{signal.integral}).

\strong{Note:  The function assumes the following sequence pattern:
\verb{DARK COUNT}, \code{IRSL}, \verb{DARK COUNT}, \code{BSL}, \verb{DARK COUNT}.} Therefore, the
total number of curves in the input object must be a multiple of 5, and
there must be 3 \code{DARK_COUNT} records for each IRSL/BSL pair. If you have used
a different sequence, the function will produce an error.

\strong{Signal processing}
The function processes the signals as follows: \code{BSL} and \code{IRSL} signals are extracted using the
chosen signal integral, dark counts are taken in full.

\strong{Working with coordinates}
Usually samples are taken from a profile with a certain stratigraphy. In the past the function
calculated an index. With this newer version, you have two option of passing on xy-coordinates
to the function:
\itemize{
\item (1) Add coordinates to the sample name during measurement. The form is rather
strict and has to follow the scheme \verb{_x:<number>|y:<number>}. Example:
\code{sample_x:0.2|y:0.4}.
\item (2) Alternatively, you can provide a \link{list} or \link{matrix} with the \emph{(x, y)}
coordinates of each sample in meters (m) using the \code{coord} argument:
Example: \code{coord = list(c(0.2, 1), c(0.3,1.2))}
}

If in your profile the x-coordinates were not measured, \emph{x} should be set
to 0. Note that, in such case, a surface plot cannot be produced.
}
\section{Function version}{
 0.1.3
}

\examples{

## example profile plot
# (1) load example data set
data("ExampleData.portableOSL", envir = environment())

# (2) merge and plot all RLum.Analysis objects
merged <- merge_RLum(ExampleData.portableOSL)
plot_RLum(
 object = merged,
 combine = TRUE,
 records_max = 5,
 legend.pos = "outside")
merged

# (3) analyse and plot
results <- analyse_portableOSL(
  merged,
  signal.integral = 1:5,
  invert = FALSE,
  normalise = TRUE)
get_RLum(results)

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Data.Curve}, \link{read_PSL2R}
}
\author{
Christoph Burow, University of Cologne (Germany) \cr
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany) \cr
Marco Colombo, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Burow, C., Kreutzer, S., Colombo, M., 2025. analyse_portableOSL(): Analyse portable CW-OSL measurements. Function version 0.1.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\keyword{datagen}
\keyword{plot}
