% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{DiscreteVariate}
\alias{DiscreteVariate}
\alias{BinomialVariate}
\alias{NegBinomialVariate}
\alias{PoissonVariate}
\title{Discrete Variate Constructors}
\usage{
BinomialVariate(x = integer(), size = integer())

DiscreteVariate(x = integer(), min = -Inf, max = Inf)

NegBinomialVariate(x = integer())

PoissonVariate(x = integer())
}
\arguments{
\item{x}{numeric vector.}

\item{size}{number or numeric vector of binomial trials.}

\item{min, max}{minimum and maximum bounds for discrete numbers.}
}
\value{
\code{BinomialVariate} object class, \code{DiscreteVariate} that
inherits from \code{numeric}, or \code{NegBinomialVariate} or
\code{PoissonVariate} that inherit from \code{DiscreteVariate}.
}
\description{
Create a variate of binomial counts, discrete numbers, negative binomial
counts, or Poisson counts.
}
\examples{
BinomialVariate(rbinom(25, 10, 0.5), size = 10)
PoissonVariate(rpois(25, 10))

}
\seealso{
\code{\link{role_binom}}
}
