% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{migraine_treatment_df}
\alias{migraine_treatment_df}
\title{Migraine Headache Treatment}
\format{
A data frame with 4,152 observations and 9 variables:
\describe{
  \item{id}{Integer: Patient identification number}
  \item{time}{Integer: Time measurement (likely days or hours)}
  \item{dos}{Integer: Treatment dosage}
  \item{hatype}{Factor with 3 levels: Headache type classification}
  \item{age}{Integer: Patient age in years}
  \item{airq}{Numeric: Air quality index measurement}
  \item{medication}{Factor with 3 levels: Medication type}
  \item{headache}{Factor with 2 levels: Headache presence/severity}
  \item{sex}{Factor with 2 levels: Patient sex}
}
}
\source{
Data taken from the carData package version 3.0-5. Original collection:
Kostecki-Dillon, T. (Year not specified) Migraine Treatment Study.
}
\usage{
data(migraine_treatment_df)
}
\description{
This dataset, migraine_treatment_df, is a data frame containing clinical data
on 4,152 migraine treatment cases collected by Tammy Kostecki-Dillon. The data
includes treatment details, headache characteristics, and patient demographics.
}
\details{
The dataset name has been kept as 'migraine_treatment_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'df' indicates
that the dataset is a data frame. The original content has not been modified.
}
