% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_functions.R
\name{set_display_digits}
\alias{set_display_digits}
\title{Package-wide number of digits}
\usage{
set_display_digits(digits = list())
}
\arguments{
\item{digits}{A list of numbers corresponding to the different
display digits. The default value is \code{list()}.}
}
\value{
No return value, called for side effects.
}
\description{
Sets the number of digits to display in the output of the
different package functions.
}
\details{
The parameter \code{digits} is a named list. It will be containing:
\itemize{
\item  \code{d1}: contains the number of display digits for the values of
probability estimates such as \eqn{\alpha}, \eqn{\delta}, \code{pin}, \code{mpin},
\code{mpin(j)}, \code{adjpin}, \code{psos}, \thetaB, and \thetaS.
\item  \code{d2}: contains the number of display digits for the values of
\eqn{\mu}, \eb and \es, as well as information criteria: \code{AIC}, \code{BIC}, and
\code{AWE}.
\item  \code{d3}: contains the number of display digits for the remaining values
such as \code{vpin} statistics and \code{likelihood} value .
}

If the function is called with no arguments, the display digits will be reset
to the default values, i.e., \code{list(d1 = 6, d2 = 2, d3 = 3))}.
If the argument \code{digits} is not omitted, the function will only accept a list
containing exactly three numerical values, each ranging
between \code{0} and \code{10}. The list can be named or unnamed. If the numbers in the
argument \code{digits} are not integers, they will be rounded.
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# We show the output of the function pin_ea() using the default values
# of display digits. We then change these values using the function
# set_display_digits(), before displaying the same estimate.pin object
# again to see the difference.

model <- pin_ea(xdata, verbose = FALSE)
show(model)

# Change the number of digits for d1 to 3, of d2 to 0 and of d3 to 2

set_display_digits(list(3, 0, 2))

# No need to run the function mpin_ml() again to update the display of an
# estimate.mpin object.This holds for all estimate* S4 objects.

show(model)

}
