% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download}
\alias{download}
\title{Download Content from PubChem and Save to a File}
\usage{
download(
  filename = NULL,
  outformat,
  path,
  identifier,
  namespace = "cid",
  domain = "compound",
  operation = NULL,
  searchtype = NULL,
  overwrite = FALSE,
  options = NULL
)
}
\arguments{
\item{filename}{a character string specifying the file name to be saved. If not specified, a default file name "file" is used.}

\item{outformat}{A character string specifying the desired output format (e.g., "sdf", "json").}

\item{path}{A character string specifying the path where the content should be saved.}

\item{identifier}{A vector of positive integers (e.g. cid, sid, aid) or identifier strings (source, inchikey, formula). In some cases, only a single
identifier string (name, smiles, xref; inchi, sdf by POST only).}

\item{namespace}{Specifies the namespace for the query. For the 'compound' domain, possible values include 'cid', 'name', 'smiles', 'inchi', 'sdf', 'inchikey',
'formula', 'substructure', 'superstructure', 'similarity', 'identity', 'xref', 'listkey', 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d',
'fastsubstructure', 'fastsuperstructure', and 'fastformula'. For other domains, the possible namespaces are domain-specific.}

\item{domain}{Specifies the domain of the query. Possible values are 'substance', 'compound', 'assay', 'gene', 'protein', 'pathway', 'taxonomy',
'cell', 'sources', 'sourcetable', 'conformers', 'annotations', 'classification', and 'standardize'.}

\item{operation}{Specifies the operation to be performed on the input records. For the 'compound' domain, possible operations include 'record',
'property', 'synonyms', 'sids', 'cids', 'aids', 'assaysummary', 'classification', 'xrefs', and 'description'. The available operations are domain-specific.}

\item{searchtype}{Specifies the type of search to be performed. For structure searches, possible values are combinations of 'substructure',
'superstructure', 'similarity', 'identity' with 'smiles', 'inchi', 'sdf', 'cid'. For fast searches, possible values are combinations of 'fastidentity',
'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure' with 'smiles', 'smarts', 'inchi', 'sdf', 'cid', or 'fastformula'.}

\item{overwrite}{A logical value indicating whether to overwrite the file if it already exists. Default is FALSE.}

\item{options}{Additional arguments.}
}
\value{
No return value. The function writes the content to the specified file path and prints a message indicating the save location.
}
\description{
This function sends a request to PubChem to retrieve content in the specified format for a given identifier.
It then writes the content to a specified file path.
}
\examples{
# Download JSON file for the compound "aspirin" into "Aspirin.JSON"
# A folder named "Compound" will be created under current directory"
download(
  filename = "Aspirin",
  outformat = "json",
  path = "./Compound",
  identifier = "aspirin",
  namespace = "name",
  domain = "compound",
  overwrite = TRUE
)

# Remove downloaded files and folders.
file.remove("./Compound/Aspirin.json")
file.remove("./Compound/")
}
