% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{semID}
\alias{semID}
\title{Identifiability of linear structural equation models.}
\usage{
semID(
  mixedGraph,
  testGlobalID = TRUE,
  testGenericNonID = TRUE,
  genericIdStepFunctions = list(htcIdentifyStep),
  tianDecompose = TRUE
)
}
\arguments{
\item{mixedGraph}{a \code{\link{MixedGraph}} object representing the L-SEM.}

\item{testGlobalID}{TRUE or FALSE if the graph should be tested for global
identifiability. This uses the \code{\link{globalID}}
function.}

\item{testGenericNonID}{TRUE of FALSE if the graph should be tested for
generic non-identifiability, that is, if for every generic choice
of parameters for the L-SEM there are infinitely many
other choices that lead to the same covariance matrix. This currently
uses the \code{\link{graphID.nonHtcID}} function.}

\item{genericIdStepFunctions}{a list of the generic identifier step functions
that should be used for testing generic identifiability. See
\code{\link{generalGenericID}} for a discussion of such functions. If
this list is empty then generic identifiability is not tested. By
default this will (only) run the half-trek criterion (see
\code{\link{htcIdentifyStep}}) for generic identifiability.}

\item{tianDecompose}{TRUE or FALSE if the mixed graph should be Tian
decomposed before running the identification algorithms
(when appropriate). In general letting this be TRUE will
make the algorithm faster and more powerful. Note that
this is a version of the Tian decomposition that works
also with cyclic graphs.}
}
\value{
returns an object of \link{class} '\code{SEMIDResult},' this
        object is just a list with 6 components:
\describe{
  \item{\code{isGlobalID}}{If testGlobalID == TRUE, then TRUE or FALSE if
  the graph is globally identifiable. If testGlobalID == FALSE then NA.}
  \item{\code{isGenericNonID}}{If testGenericNonID == TRUE, then TRUE if the
  graph is generically non-identifiable or FALSE the test is inconclusive.
  If testGenericNonID == FALSE then NA.}
  \item{\code{genericIDResult}}{If length(genericIdStepFunctions) != 0 then
  a \code{GenericIDResult} object as returned by
  \code{\link{generalGenericID}}. Otherwise a list of length 0.}
  \item{\code{mixedGraph}}{the inputted mixed graph object.}
  \item{\code{tianDecompose}}{the argument tianDecompose.}
  \item{\code{call}}{the call made to this function.}
}
}
\description{
This function can be used to check global and generic identifiability of
linear structural equation models (L-SEMs). In particular, this function
takes a \code{\link{MixedGraph}} object corresponding to the L-SEM and
checks different conditions known for global and generic identifiability.
}
\examples{
\dontrun{
L = t(matrix(
  c(0, 1, 0, 0, 0,
    0, 0, 1, 0, 0,
    0, 0, 0, 1, 0,
    0, 0, 0, 0, 1,
    0, 0, 0, 0, 0), 5, 5))
O = t(matrix(
  c(0, 0, 1, 1, 0,
    0, 0, 0, 1, 1,
    0, 0, 0, 0, 0,
    0, 0, 0, 0, 0,
    0, 0, 0, 0, 0), 5, 5))
O = O + t(O)
graph = MixedGraph(L,O)
semID(graph)

## Examples from Foygel, Draisma & Drton (2012)
demo(SEMID)
}
}
