% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPipelineOnlist.R
\name{annotate}
\alias{annotate}
\title{Run the annotation pipeline on a list of variants}
\usage{
annotate(
  rslist,
  server,
  db,
  outputPath,
  window_size = 500,
  r2 = 0.5,
  LDlist = TRUE,
  cadd = FALSE,
  geneNames.file = NULL,
  regulatoryType.file = NULL,
  cores = 0
)
}
\arguments{
\item{rslist}{A vector of rs numbers.}

\item{server}{Name of the server. "https://rest.ensembl.org" can be used for GRCh38
and "https://grch37.rest.ensembl.org" for GRCh37.}

\item{db}{The population database for calculating LD scores. This can be found using \code{listDatabases} function.}

\item{outputPath}{The report file will be saved in this path as an Excel file (.xlsx)}

\item{window_size}{Number of base pairs around the variant for checking LD scores (max = 500kb)}

\item{r2}{The LD threshold for selecting variants around the target SNP.}

\item{LDlist}{If set to TRUE, variants in high LD will be found and added to the output.}

\item{cadd}{If set to TRUE, the CADD scores will be added to variant information.}

\item{geneNames.file}{path the gene information file (*.rds). Default value is NULL and ENSEMBL website will be checked if no file is provided.}

\item{regulatoryType.file}{path the variants regulatory type information file (*.rds). Default value is NULL and this step will be skipped if no file is provided.}

\item{cores}{set to a value above 0 for parallel processing.}
}
\value{
a data table with all variant information is returned.
}
\description{
This function receives a list of variants and checks their information on Ensembl website via
the Ensembl REST API server.
}
\examples{
\dontrun{
# select the required server
server <- "https://grch37.rest.ensembl.org"

# select the database for population data
# this can be selected from listDatabases() function
db <- "1000GENOMES:phase_3:EUR"

# create a vector of required SNPs
rslist=c('rs236349')

output <- annotate(rslist,server,db,
  outputPath = paste(tempdir(),'sampleOutput.xlsx',sep="/"),
  window_size = 500,
  r2 = .9,
  cadd = FALSE)
  }

}
