% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{trajectory,SimInf_pmcmc-method}
\alias{trajectory,SimInf_pmcmc-method}
\title{Extract filtered trajectories from fitting a PMCMC algorithm}
\usage{
\S4method{trajectory}{SimInf_pmcmc}(model, compartments, index, start = 1, end = NULL, thin = 1)
}
\arguments{
\item{model}{the \code{SimInf_pmcmc} object to extract the
filtered trajectories from.}

\item{compartments}{specify the names of the compartments to
extract data from. The compartments can be specified as a
character vector e.g. \code{compartments = c('S', 'I', 'R')},
or as a formula e.g. \code{compartments = ~S+I+R} (see
\sQuote{Examples}). Default (\code{compartments=NULL}) is to
extract the number of individuals in each compartment i.e. the
data from all discrete state compartments in the model. In
models that also have continuous state variables e.g. the
\code{SISe} model, they are also included.}

\item{index}{indices specifying the subset of nodes to include
when extracting data. Default (\code{index = NULL}) is to
extract data from all nodes.}

\item{start}{The start iteration to remove some burn-in
iterations. Default is \code{start = 1}.}

\item{end}{the last iteration to include. Default is \code{NULL}
which set \code{end} to the last iteration in the chain.}

\item{thin}{keep every \code{thin} iteration after the
\code{start} iteration. Default is \code{thin = 1}, i.e., keep
every iteration.}
}
\value{
A \code{data.frame} where the first column is the
    \code{iteration} and the remaining columns are the result from
    calling \code{\link{trajectory,SimInf_model-method}} with the
    arguments \code{compartments} and \code{index} for each
    iteration.
}
\description{
Extract filtered trajectories from a particle Markov chain Monte
Carlo algorithm.
}
