% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{showProbPlot}
\alias{showProbPlot}
\title{Show distribution plots of the cell proportions generated by
\code{\link{genMixedCellProp}}}
\usage{
showProbPlot(object, type.data, set, type.plot = "boxplot")
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with
\code{prob.cell.types} slot with \code{plot} slot.}

\item{type.data}{Subset of data to show: \code{train} or \code{test}.}

\item{set}{Integer determining which of the 6 different subsets to display.}

\item{type.plot}{Character determining which type of visualization to
display. It can be \code{'boxplot'}, \code{'violinplot'},
\code{'linesplot'} or \code{'ncelltypes'}. See Description for more
information.}
}
\value{
A ggplot object.
}
\description{
Show distribution plots of the cell proportions generated by the
\code{\link{genMixedCellProp}} function.
}
\details{
These frequencies will determine the proportion of different cell types used
during the simulation of mixed transcriptional profiles. Proportions
generated by each method (see \code{?\link{genMixedCellProp}}) can be
visualized in three ways: box plots, violin plots, and lines plots. You can
also plot the probabilities based on the number of different cell types
present in the samples by setting \code{type.plot = 'nCellTypes'}.
}
\examples{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(100, lambda = 5), nrow = 40, ncol = 30,
      dimnames = list(paste0("Gene", seq(40)), paste0("RHC", seq(30)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(30)),
    Cell_Type = sample(x = paste0("CellType", seq(4)), size = 30,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(40))
  )
)

SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  project = "Simul_example",
  sc.filt.genes.cluster = FALSE
)
SDDLS <- genMixedCellProp(
  object = SDDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  num.sim.spots = 10, 
  train.freq.cells = 2/3,
  train.freq.spots = 2/3,
  verbose = TRUE
)
showProbPlot(
   SDDLS,
   type.data = "train",
   set = 1,
   type.plot = "boxplot"
 )
 
}
\seealso{
\code{\link{genMixedCellProp}}
}
