% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owen.R
\name{owen}
\alias{owen}
\title{Owen value}
\usage{
owen(
  characteristic_func,
  union,
  method = "exact",
  n_rep = 10000,
  n_players = 0
)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players.}

\item{union}{List of vectors indicating the a priori unions between the
players.}

\item{method}{Method used to calculate the Owen value. Valid methods are:
\code{exact} for the exact calculation or \code{appro} for approximated polynomial
calculation based on sampling.}

\item{n_rep}{Only used if \code{method} is \code{appro}. The number of
iterations to perform in the approximated calculation.}

\item{n_players}{The number of players in the game.}
}
\value{
The Owen value for each player.
}
\description{
Calculate the Owen value
}
\examples{
n <- 10
v <- function(coalition) {
  if (length(coalition) > n/2) {
    return(1)
  } else {
    return(0)
  }
}
u <- lapply(1:(n/2), function(i) c(2*i - 1, 2*i))
owen(v, union = u, method = "appro", n_rep = 4000, n_players = n)

characteristic_func <- c(1,1,2,1,2,2,2)
union <- list(c(1,2),c(3))
owen(characteristic_func, union)
owen(characteristic_func, union, method = "appro", n_rep = 4000)

}
