% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.abesspca.R
\name{plot.abesspca}
\alias{plot.abesspca}
\title{Creat plot from a fitted "\code{abess}" object}
\usage{
\method{plot}{abesspca}(x, type = c("pev", "coef", "tune"), label = FALSE, ...)
}
\arguments{
\item{x}{A "\code{abess}" object.}

\item{type}{The type of terms to be plot in the y-axis.
One of the following:
\code{"pev"} (i.e., percent of explained variance),
\code{"coef"} (i.e., coefficients),
and \code{"tune"} (i.e., tuning value).
Default is \code{"coef"}.}

\item{label}{A logical value.
If \code{label = TRUE} (the default),
label the curves with variable sequence numbers.}

\item{...}{Other graphical parameters to plot}
}
\value{
No return value, called for side effects.
}
\description{
Produces a coefficient/deviance/tuning-value plot
for a fitted "abess" object.
}
\note{
If \code{family = "mgaussian"} or \code{family = "multinomial"},
a coefficient plot is produced for
each dimension of multivariate response.
}
\examples{
abess_fit <- abesspca(USArrests, support.size = 1:4, sparse.type = "kpc")
plot(abess_fit)
plot(abess_fit, type = "coef")
plot(abess_fit, type = "tune")
}
\seealso{
\code{\link{print.abesspca}},
\code{\link{coef.abesspca}},
\code{\link{plot.abesspca}}.
}
