% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gamma_regression.R
\name{plot_gamma}
\alias{plot_gamma}
\title{Function for plotting the gamma regression for the mean-variance trend}
\usage{
plot_gamma(data)
}
\arguments{
\item{data}{The data to use for producing the plots.}
}
\value{
a plot with the estimated mean-variance trend
}
\description{
Generates a scatter plot with the gamma regressions of the mean-variance
trends without partitioning
}
\examples{
# Produce a design matrix
design <- model.matrix(~ 0 + factor(rep(1:2, each = 3)))
colnames(design) <- paste0("ng", c(50, 100))

# Normalize and log transform the data
yeast_norm <- psrn(yeast, "identifier")

# Generate the plot
yeast_norm \%>\%
  calculate_mean_sd_trends(design) \%>\%
  plot_gamma()
}
