% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_bma}
\alias{setup_bma}
\title{Setup bma Design Object}
\usage{
setup_bma(k, p0, shape1 = 1, shape2 = 1)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{shape1}{First common shape parameter of the beta prior.}

\item{shape2}{Second common shape parameter of the beta prior.}
}
\value{
An S3 object of class \code{bma}
}
\description{
Creates an object of class \code{bma}.
}
\details{
The class \code{bma} implements the Bayesian Model Averaging
design by Pisoda et al. (2021). Functions for this class are mostly
wrappers for functions of the \code{bmabasket} package.
}
\examples{
design_bma <- setup_bma(k = 3, p0 = 0.2)
}
\references{
Psioda, M. A., Xu, J., Jiang, Q. I., Ke, C., Yang, Z., &
Ibrahim, J. G. (2021). Bayesian adaptive basket trial design using model
averaging. Biostatistics, 22(1), 19-34.
}
