% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{round_track_time}
\alias{round_track_time}
\title{Round time to nearest interval}
\usage{
round_track_time(dat, id, int, tol, time.zone = "UTC", units)
}
\arguments{
\item{dat}{A data frame that contains the sampling interval of the
observations.}

\item{id}{character. The name of the column storing the animal IDs.}

\item{int}{numeric. A vector of the time interval(s) of on which to perform
rounding.}

\item{tol}{numeric. A single tolerance value on which to round any \code{int}
that were specified.}

\item{time.zone}{character. Specify the time zone for which the date-times
were recorded. Set to UTC by default. Refer to \code{base::OlsonNames} to view
all possible time zones.}

\item{units}{character. The units of the selected time interval \code{int},
which can be selected from one of "secs", "mins", "hours", "days", or
"weeks".}
}
\value{
A data frame where \code{dt} and \code{date} are both adjusted based
  upon the rounding of time intervals according to the specified tolerance.
}
\description{
Rounds sampling intervals that are close, but not exactly the time interval
of interest (e.g., 240 s instead of 300 s). This can be performed on multiple
time intervals, but only using a single tolerance value. This function
prepares the data to be analyzed by \code{\link{segment_behavior}}, which
requires that all time intervals exactly match the primary time interval when
analyzing step lengths and turning angles. Columns storing the time intervals
and dates must be labeled \code{dt} and \code{date}, respectively, where
dates are of class \code{POSIXct}.
}
\examples{
#load data
data(tracks)

#subset only first track
tracks<- tracks[tracks$id == "id1",]

#calculate step lengths and turning angles
tracks<- prep_data(dat = tracks, coord.names = c("x","y"), id = "id")

#round times to nearest interval of interest (e.g. 3600 s or 1 hr)
tracks<- round_track_time(dat = tracks, id = "id", int = 3600, tol = 180, time.zone = "UTC",
                          units = "secs")

}
