#' yangtze Bayesian Network
#'
#' Towards system-theoretic risk management for maritime transportation systems: A case study of the yangtze river estuary.
#'
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network to determine the probabilities and consequences of accident scenarios in maritime transportation systems. Probabilities were given within the referenced paper (some inconsistencies in the numbers provided). The vertices are:
#' \describe{
#'   \item{AssessmentFailure}{Assessment failure (Yes, No);}
#'   \item{AvoidanceRules}{Strengthen the study of international maritime ship collision avoidance rules (Adopted, Unadopted);}
#'   \item{CautiousDriving}{Cautious driving to keep lookout in the cautionary area of YRE (Adopted, Unadopted);}
#'   \item{Collision}{Collision probability (Yes, No);}
#'   \item{CompetentCrew}{Failure to have a competent crew (Yes, No);}
#'   \item{ConsequenceCollision}{Collision consequence (Serious, Moderate, Minor);}
#'   \item{ConsequenceContact}{Contact consequence (Serious, Moderate, Minor);}
#'   \item{ConsequenceSinking}{Sinking consequence (Serious, Moderate, Minor);}
#'   \item{Contact}{Contact probability (Yes, No);}
#'   \item{CrewTraining}{Strengthen crew training on operation in narrow and crowded waters (Adopted, Unadopted);}
#'   \item{EarlyMeasures}{Failure to take early measures (Yes, No);}
#'   \item{EquipmentFailure}{Operation equipment failure (Yes, No);}
#'   \item{GrossTonnage}{Gross tonnage (< 3000 tons, 3000-10000 tons, > 10000 tons);}
#'   \item{HardwareMaintenance}{Strengthen ship hardware maintenance and management (Adopted, Unadopted);}
#'   \item{ImproperStowage}{Improper stowage (Yes, No);}
#'   \item{InadequateCommunication}{Inadequate communication (Yes, No);}
#'   \item{NegligentLookout}{Negligent lookout (Yes, No);}
#'   \item{NoGiveWay}{No give way (Yes, No);}
#'   \item{QualifiedCrew}{Strengthen the supervision of competent crew according to law (Adopted, Unadopted);}
#'   \item{ResourceManagement}{Enhance teamwork resource management training on the bridge (Adopted, Unadopted);}
#'   \item{SafetyTraining}{Strengthening crew safety awareness training (general) (Adopted, Unadopted);}
#'   \item{ShipAge}{Ship age (<10 years, 10-20 years, > 20 years);}
#'   \item{ShipTracking}{Strengthen ship tracking management (Adopted, Unadopted);}
#'   \item{ShipType}{Ship type (Carrier/Container, Tanker, Other ship);}
#'   \item{Sinking}{Sinking probability (Yes, No);}
#'   \item{SupervisingCompanies}{Strengthen the inspection of the effectiveness of safety management of supervising shipping companies (Adopted, Unadopted);}
#'   \item{SupervisionVessel}{Strengthen the supervision of inland river vessel companies by the YRE port and navigation department (Adopted, Unadopted);}
#'   \item{TrafficFlow}{Traffic flow (Heavy, NormalOrLow);}
#'   \item{UnsafeSpeed}{Unsafe speed (Yes, No);}
#'   \item{Visibility}{Visibility (Poor, Good);}
#'   \item{Wind}{Wind (>= Category 5, < Category 5).}
#' }
#'
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#' @keywords NULL
#' @importClassesFrom bnlearn bn.fit
#' @references Fu, S., Gu, S., Zhang, Y., Zhang, M., & Weng, J. (2023). Towards system-theoretic risk management for maritime transportation systems: A case study of the yangtze river estuary. Ocean Engineering, 286, 115637.
"yangtze"
