% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_table_gt}
\alias{br_show_table_gt}
\title{Show regression models with \code{gtsummary} interface}
\usage{
br_show_table_gt(breg, idx = NULL, ..., tab_spanner = NULL)
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{idx}{Index or names (focal variables) of the model(s).}

\item{...}{Arguments passing to \code{\link[gtsummary:tbl_regression]{gtsummary::tbl_regression()}} excepts \code{x}.}

\item{tab_spanner}{(\code{character})\cr
Character vector specifying the spanning headers.
Must be the same length as \code{tbls}. The
strings are interpreted with \code{gt::md}.
Must be same length as \code{tbls} argument. Default is \code{NULL}, and places
a default spanning header. If \code{FALSE}, no header will be placed.}
}
\value{
A table
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Provides an interface to visualize the model results with \href{https://github.com/ddsjoberg/gtsummary/}{\strong{gtsummary}} package in table format.
check \url{https://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html#customize-output} to see possible output customization.
}
\examples{
if (rlang::is_installed("gtsummary")) {
  m <- br_pipeline(mtcars,
    y = "mpg",
    x = colnames(mtcars)[2:4],
    x2 = "vs",
    method = "gaussian"
  )
  br_show_table_gt(m)
}

}
\seealso{
Other br_show: 
\code{\link{br_show_coxph_diagnostics}()},
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_circle}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_nomogram}()},
\code{\link{br_show_residuals}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_survival_curves}()},
\code{\link{br_show_table}()}
}
\concept{br_show}
