% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence_rates_ratio.R
\name{incidence_rates_ratio}
\alias{incidence_rates_ratio}
\title{Compute incidence rates ratio}
\usage{
incidence_rates_ratio(ncan, py, ncanref, pyref, ncan.min = 5)
}
\arguments{
\item{ncan}{integer, number of cancers in the population of interest}

\item{py}{integer, person-year of the the population of interest}

\item{ncanref}{integer, number of cancers in the reference population}

\item{pyref}{integer, person-year of the the reference population}

\item{ncan.min}{integer, minimum number of observation required not to mask the CI's out

Incidence rates ratio and associated 95\% confidence interval are computing assuming normal distribution of the ratios on the log scale.}
}
\value{
a 3 column data.frame containing the incidence rates ratio (est) and associated 95\% CI (lci, uci)
}
\description{
Compute incidence rates ratio
}
\examples{
ncan <- 1:10
py <- 101:110
ncanref <- 41:50
pyref <- 251:260
ncan.min <- 5

incidence_rates_ratio(ncan, py, ncanref, pyref, ncan.min)
}
\references{
Boyle P, Parkin DM. Cancer registration: principles and methods. Statistical methods for registries. IARC Sci Publ. 1991;(95):126-58. PMID: 1894318.
}
\concept{summary-stat}
