% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_standardized_incidence_rates.R
\name{age_standardized_incidence_rates}
\alias{age_standardized_incidence_rates}
\title{Age-standardized incidence rate (asir)}
\usage{
age_standardized_incidence_rates(ncan, py, pystd, ncan.min = 5, py.min = 0)
}
\arguments{
\item{ncan}{integer, (age-specific) number of cancers in the population of interest}

\item{py}{integer, (age-specific) person-year in the the population of interest}

\item{pystd}{numeric, (age-specific) standard population person-years (e.g. standard world population)}

\item{ncan.min}{integer, minimum number of observation required not to mask the CI's out}

\item{py.min}{integer, minimum person-years required not to mask the CI's out

Age-standardized incidence rate (asir) and associated 95\% confidence interval are computing assuming normal distribution of the asir.
asir is a summary statistics that should be computed per group of individuals providing age specific counts.}
}
\value{
a 1 line and 3 column data.frame containing the asir (est) and associated 95\% CI (lci, uci)
}
\description{
Age-standardized incidence rate (asir)
}
\examples{
ncan <- 1:10
py <- 101:110
pystd <- 10:1
ncan.min <- 5
age_standardized_incidence_rates(ncan, py, pystd, ncan.min)
age_standardized_incidence_rates(ncan, py, pystd, sum(ncan) + 1)
}
\references{
Boyle P, Parkin DM. Cancer registration: principles and methods. Statistical methods for registries. IARC Sci Publ. 1991;(95):126-58. PMID: 1894318.
}
\concept{summary-stat}
