% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{coembedding_umap}
\alias{coembedding_umap}
\title{Calculate UMAP projections for coembedding of cells and features}
\usage{
coembedding_umap(
  seu,
  reduction,
  reduction.name,
  gene.set = NULL,
  slot = "data",
  assay = "RNA",
  seed = 1
)
}
\arguments{
\item{seu}{a Seurat object with coembedding in the reductions slot wiht component name reduction.}

\item{reduction}{a string, specify the reduction component that denotes coembedding.}

\item{reduction.name}{a string, specify the reduction name for the obtained UMAP projection.}

\item{gene.set}{a string vector,  specify the features (genes) in calculating the UMAP projection, default as all features.}

\item{slot}{an optional string,  specify the slot in the assay, default as `data`.}

\item{assay}{an optional string,  specify the assay name in the Seurat object when adding the UMAP projection.}

\item{seed}{an optional integer, specify the random seed for reproducibility.}
}
\value{
return a revised Seurat object by adding a new reduction component named `reduction.name`.
}
\description{
Calculate UMAP projections for coembedding of cells and features
}
\details{
None
}
\examples{
library(Seurat)
data(pbmc3k_subset)
data(top5_signatures)
\donttest{
pbmc3k_subset <- coembedding_umap(
  pbmc3k_subset, reduction = "ncfm", reduction.name = "UMAPsig",
  gene.set = top5_signatures$gene
)
}


}
\references{
None
}
\seealso{
None
}
