% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_env_qual.R
\name{reconstruct_env_qual}
\alias{reconstruct_env_qual}
\title{Reconstruct past qualitative environmental categories using ecometric models}
\usage{
reconstruct_env_qual(
  fossildata,
  model_out,
  match_nearest = TRUE,
  fossil_lon = NULL,
  fossil_lat = NULL,
  modern_id = NULL,
  modern_lon = NULL,
  modern_lat = NULL,
  crs_proj = 4326
)
}
\arguments{
\item{fossildata}{A data frame containing fossil trait summaries per fossil site.
Must include columns corresponding to the same two summary metrics used for modern communities,
using the column names specified by \code{fossil_summ_trait_1} and \code{fossil_summ_trait_2}.}

\item{model_out}{Output list from \code{ecometric_model_qual()}, containing modern data, diagnostics, and model settings.}

\item{match_nearest}{Logical; if TRUE, matches each fossil to the nearest modern point (default = TRUE).}

\item{fossil_lon}{Name of the longitude column in \code{fossildata}. Required if \code{match_nearest = TRUE}.}

\item{fossil_lat}{Name of the latitude column in \code{fossildata}. Required if \code{match_nearest = TRUE}.}

\item{modern_id}{Name of the unique ID column in modern points (optional for metadata merging).}

\item{modern_lon}{Name of the longitude column in modern points. Required if \code{match_nearest = TRUE}.}

\item{modern_lat}{Name of the latitude column in modern points. Required if \code{match_nearest = TRUE}.}

\item{crs_proj}{Coordinate reference system for sf operations (default = EPSG:4326).}
}
\value{
A data frame (\code{fossildata}) updated with:
\describe{
\item{fossil_bin_1}{Assigned bin number for the first trait axis (based on first summary metric of trait distribution of fossil communities).}
\item{fossil_bin_2}{Assigned bin number for the second trait axis (based on second summary metric of trait distribution of fossil communities).}
\item{fossil_env_est}{Predicted environmental category based on trait bin.}
\item{fossil_prob_*}{Probability of each environmental category for the assigned bin.}
\item{nearest_modern_point}{(Optional) ID of the nearest modern sampling point (if \code{match_nearest = TRUE}).}
\item{...}{Additional columns from the matched modern site if \code{match_nearest = TRUE}.}
}
}
\description{
Uses fossil community trait summaries to reconstruct the most likely
environmental category by projecting them onto a qualitative ecometric space
built from modern data. Optionally, it assigns each fossil point to the nearest modern sampling point.
}
\examples{
\donttest{
# Load internal data
data("geoPoints", package = "commecometrics")
data("traits", package = "commecometrics")
data("spRanges", package = "commecometrics")
data("fossils", package = "commecometrics")

# Step 1: Summarize trait values at sampling points
traitsByPoint <- summarize_traits_by_point(
  points_df = geoPoints,
  trait_df = traits,
  species_polygons = spRanges,
  trait_column = "RBL",
  species_name_col = "sci_name",
  continent = FALSE,
  parallel = FALSE
)

# Step 2: Run a qualitative ecometric model (e.g., land cover class)
ecoModelQual <- ecometric_model_qual(
  points_df = traitsByPoint$points,
  category_col = "vegetation",
  min_species = 3
)

# Step 3: Reconstruct qualitative environments for fossil data
reconQual <- reconstruct_env_qual(
  fossildata = fossils,
  model_out = ecoModelQual,
  match_nearest = TRUE,
  fossil_lon = "Long",
  fossil_lat = "Lat",
  modern_id = "ID",
  modern_lon = "Longitude",
  modern_lat = "Latitude"
)
}
}
