% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse_contrasts.R
\name{.warn_if_mismatched_contrasts}
\alias{.warn_if_mismatched_contrasts}
\title{Diagnose glimpse issues and send warnings}
\usage{
.warn_if_mismatched_contrasts(
  model_data,
  contrast_list,
  model_data_name,
  dots_names,
  formulas
)
}
\arguments{
\item{model_data}{Data user passed to \code{\link[=glimpse_contrasts]{glimpse_contrasts()}}}

\item{contrast_list}{List of contrasts created by \code{\link[=enlist_contrasts]{enlist_contrasts()}}}

\item{model_data_name}{Name of the dataframe passed to the user, will be
truncated if it's a long expression that has (likely) been piped}

\item{dots_names}{Usually "...", in this case, the \code{...} filled in by the
user (ie contrast formulas) will need to be expanded in the suggested fixes}

\item{formulas}{Formulas passed by the user}
}
\value{
Nothing, issues warnings to the user.
}
\description{
\code{\link[=glimpse_contrasts]{glimpse_contrasts()}} does not modify the dataframe passed to it, which can
result in mismatches between the data the user will use and the glimpse
information presented. This runs many diagnostics to inform the use of such
mismatches and provides suggestions on how to fix the issue.
}
\keyword{internal}
