% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse_contrasts.R
\name{.warn_if_nondefault}
\alias{.warn_if_nondefault}
\title{Warn user if nondefault contrasts are set}
\usage{
.warn_if_nondefault(
  contrast_list,
  factor_names,
  factor_sizes,
  which_ordered,
  schemes_to_use
)
}
\arguments{
\item{contrast_list}{List of contrasts like that generated by
\code{enlist_contrasts}}

\item{factor_names}{Names of the factors, also the names of the contrast list}

\item{factor_sizes}{Number of levels for each factor}

\item{which_ordered}{Which of the factors are ordered}

\item{schemes_to_use}{Character vector of schemes, if any don't match the
default for a factor, it will be replaced wtih ??? in th eoutput}
}
\value{
Warns if non default contrasts are set, returns schemes_to_use with
modifications if necessary
}
\description{
R automatically assigns specific contrast schemes to ordered and unordered
factors as specified in \code{options('contrasts')} but users are of course free
to set these on the factor themselves. But, if they do this outside of a call
to \code{glimpse_contrasts} it's hard and time consuming to check what they set
against the different possible common schemes. So, rather than checking all
possible combinations, this will only check against the defaults R already
uses and alert the user if something else is set.
}
