% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vendor.R
\name{vendor}
\alias{vendor}
\title{Vendor the cpp4r headers}
\usage{
vendor(path = "./src/vendor")
}
\arguments{
\item{path}{The directory to vendor the headers into}
}
\value{
The path to the vendored code (invisibly).
}
\description{
Vendoring is the act of making your own copy of the 3rd party packages your
project is using. It is often used in the go language community.
}
\details{
This function vendors cpp4r into your package by copying the cpp4r
headers into the \code{inst/include} folder of your package and adding
'cpp4r version: XYZ' to the top of the files, where XYZ is the version of
cpp4r currently installed on your machine.

\strong{Note}: vendoring places the responsibility of updating the code on
\strong{you}. Bugfixes and new features in cpp4r will not be available for your
code until you run \code{cpp_vendor()} again.
}
\examples{
# create a new directory
dir <- paste0(tempdir(), "/", gsub("\\\\s+|[[:punct:]]", "", Sys.time()))
dir.create(dir, recursive = TRUE)

# vendor the cpp4r headers into the directory
vendor(dir)

list.files(file.path(dir, "src", "vendor"))

# cleanup
unlink(dir, recursive = TRUE)
}
