% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainingPredictions.R
\name{DownloadTrainingPredictions}
\alias{DownloadTrainingPredictions}
\title{Download training predictions on a specified data set.}
\usage{
DownloadTrainingPredictions(
  project,
  predictionId,
  filename,
  encoding = "UTF-8"
)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{predictionId}{character. ID of the prediction to retrieve training
predictions for.}

\item{filename}{character. Filename of file to save reason codes rows}

\item{encoding}{character. Optional. Character string A string representing the encoding
to use in the output file, defaults to 'UTF-8'.}
}
\value{
NULL, but will produce a CSV with a dataframe with out-of-fold predictions for the
  training data.
}
\description{
Download training predictions on a specified data set.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  predictions <- ListTrainingPredictions(projectId)
  predictionId <- predictions[[1]]$predictionId
  file <- file.path(tempdir(), "myTrainingPredictions.csv")
  DownloadTrainingPredictions(projectId, predictionId, file)
}
}
