% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascii_tables.R
\name{as_fmt_char}
\alias{as_fmt_char}
\alias{as_fmt_char.numeric}
\alias{as_fmt_char.NULL}
\alias{as_fmt_char.list}
\alias{as_fmt_char.factor}
\alias{as_fmt_char.character}
\alias{as_fmt_char.default}
\alias{as_fmt_char.POSIXt}
\title{Format vector to printable string}
\usage{
as_fmt_char(x, ...)

\method{as_fmt_char}{numeric}(x, ...)

\method{as_fmt_char}{`NULL`}(x, ...)

\method{as_fmt_char}{list}(x, ...)

\method{as_fmt_char}{factor}(x, ...)

\method{as_fmt_char}{character}(x, add_quotes = TRUE, crop_at = 30, ...)

\method{as_fmt_char}{default}(x, ...)

\method{as_fmt_char}{POSIXt}(x, ...)
}
\arguments{
\item{x}{(\code{vector}) \cr vector to be converted to character}

\item{...}{additional arguments (not currently used)}

\item{add_quotes}{(\code{logical}) \cr if true will wrap strings that contain
whitespace with quotes}

\item{crop_at}{(\code{numeric}) \cr specifies the limit at which strings should
be truncated to}
}
\description{
Coerces a vector of any type into a printable string. The most
significant transformation is performed on existing character
vectors which will be truncated, have newlines converted
to explicit symbols and will be wrapped in quotes if they
contain white space.
}
\keyword{internal}
