% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{lang2str}
\alias{lang2str}
\title{Convert an expression into a string}
\usage{
lang2str(x)
}
\arguments{
\item{x}{Expression to convert to a string.}
}
\value{
A character string suitable for printing.
}
\description{
The opposite of \code{\link[=str2lang]{str2lang()}}, \code{\link[=lang2str]{lang2str()}} converts an
\link[=elixir-expression]{expression} into a character string. Note that
\code{\link[=lang2str]{lang2str()}} does not support the normal expression syntax for \code{elixir}, so
just expects an already-parsed expression.
}
\details{
This function is essentially identical to \code{\link[=deparse1]{deparse1()}}, which has been
available since R 4.0.0, except with \code{collapse = ""} instead of
\code{collapse = " "}.
}
\examples{
lang2str(quote(a + b + c))
}
