% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multifabCIhom.R
\name{fabtwzCI}
\alias{fabtwzCI}
\title{FAB t-interval with z-optimal w-function}
\usage{
fabtwzCI(y, s2, df, muw, t2w, s2w, alpha = 0.05)
}
\arguments{
\item{y}{a numeric vector with at least two non-missing values}

\item{s2}{a variance estimate}

\item{df}{degrees of freedom corresponding to \code{s2}}

\item{muw}{prior expectation of the mean}

\item{t2w}{prior variance of the  mean}

\item{s2w}{assumed population variance}

\item{alpha}{the type I error rate, so 1-alpha is the coverage rate}
}
\description{
Computation of a 1-alpha FAB t-interval using the w-function of
the optimal FAB z-interval
}
\details{
Internal function for multifabCIhom. It's similar to fabtCI, the 
difference being that fabtwzCI uses the w-function that leads to the 
optimal CI if the sampling variance were known.
}
\examples{
y<-rnorm(10)
fabtwzCI(y,10,9,1,5,10)
fabtwzCI(y,1/10,9,1,5,1/10)
fabtwzCI(y,10,1,9,5,10)
fabtwzCI(y,1/10,9,1,5,1/10)

}
\author{
Chaoyu Yu
}
\keyword{internal}

