% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facilityR0.R
\name{facilityR0}
\alias{facilityR0}
\title{Calculate basic reproduction number R0}
\usage{
facilityR0(S, C, A, transm, initS, mgf = NULL)
}
\arguments{
\item{S}{A matrix of state transition rates between and removal from the susceptible states in the absence of colonized individuals}

\item{C}{A matrix of state transition rates between and removal from the colonized states}

\item{A}{A matrix describing transitions from susceptible to colonized states at acquisition}

\item{transm}{A vector of transmission rates from each colonized state}

\item{initS}{A vector of admission state probabilities to each susceptible state}

\item{mgf}{The moment generating function characterizing the time-of-stay-dependent removal hazard}
}
\value{
A number (R0)
}
\description{
Calculate basic reproduction number R0
}
\examples{
S <- rbind(c(-1,2),c(1,-2))
C <- rbind(c(-1.1,0),c(0.1,-0.9))
A <- rbind(c(1,0),c(0,2))
transm <- c(0.4,0.6)
initS <- c(0.9,0.1)
mgf <- function(x, deriv=0) MGFgamma(x, rate=0.01, shape=3.1, deriv)
facilityR0(S,C,A,transm,initS,mgf)

}
