% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_stacked_metrics.R
\name{plot.stacked_metrics}
\alias{plot.stacked_metrics}
\title{Plot stacked Metrics}
\usage{
\method{plot}{stacked_metrics}(x, ...)
}
\arguments{
\item{x}{\code{stacked_metrics} object}

\item{...}{other plot parameters}
}
\value{
\code{ggplot2} object
}
\description{
Stacked metrics is like plot for \code{chosen_metric} but with all unique metrics stacked on top of each other.
Metrics containing NA's will be dropped to enable fair comparison.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) - 1

lm_model <- glm(Risk ~ .,
  data = german,
  family = binomial(link = "logit")
)


explainer_lm <- DALEX::explain(lm_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_lm,
  protected = german$Sex,
  privileged = "male"
)

sm <- stack_metrics(fobject)
plot(sm)
\donttest{

rf_model <- ranger::ranger(Risk ~ .,
  data = german,
  probability = TRUE,
  num.trees = 200
)

explainer_rf <- DALEX::explain(rf_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_rf, fobject)

sm <- stack_metrics(fobject)
plot(sm)
}

}
