% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horizFPNS.R
\name{horizFPNS}
\alias{horizFPNS}
\title{Horizontal Functional Principal Component Analysis}
\usage{
horizFPNS(warp_data, var_exp = 0.99, ci = c(-1, 0, 1), showplot = TRUE)
}
\arguments{
\item{warp_data}{fdawarp object from \link{time_warping} of aligned data}

\item{var_exp}{compute no based on value percent variance explained (example: 0.95)}

\item{ci}{geodesic standard deviations (default = c(-1,0,1))}

\item{showplot}{show plots of principal directions (default = T)}
}
\value{
Returns a hfpns object containing \item{gam_pns}{warping functions principal directions}
\item{psi_pns}{srvf principal directions}
\item{PNS}{PNS object}
}
\description{
This function calculates vertical functional principal nested sphere analysis
on aligned data
}
\examples{
hfpns <- horizFPNS(simu_warp)
}
\references{
Yu, Q., Lu, X., and Marron, J. S. (2017), “Principal
Nested Spheres for Time-Warped Functional Data Analysis,” Journal
of Computational and Graphical Statistics, 26, 144–151.
}
\keyword{alignment}
\keyword{srvf}
