\name{ulong-class}
\alias{ulong-class}
\alias{slong-class}
\alias{ulong}
\alias{slong}
\alias{ulong.array}
\alias{slong.array}
\alias{!,ulong-method}
\alias{!,slong-method}
\alias{\%*\%,ANY,ulong-method}
\alias{\%*\%,ANY,slong-method}
\alias{\%*\%,ulong,ANY-method}
\alias{\%*\%,slong,ANY-method}
\alias{\%*\%,ulong,slong-method}
\alias{\%*\%,slong,slong-method}
\alias{\%*\%,ulong,ulong-method}
\alias{\%*\%,slong,ulong-method}
\alias{\%*\%,ulong,fmpz-method}
\alias{\%*\%,slong,fmpz-method}
\alias{\%*\%,ulong,fmpq-method}
\alias{\%*\%,slong,fmpq-method}
\alias{\%*\%,ulong,mag-method}
\alias{\%*\%,slong,mag-method}
\alias{\%*\%,ulong,arf-method}
\alias{\%*\%,slong,arf-method}
\alias{\%*\%,ulong,acf-method}
\alias{\%*\%,slong,acf-method}
\alias{\%*\%,ulong,arb-method}
\alias{\%*\%,slong,arb-method}
\alias{\%*\%,ulong,acb-method}
\alias{\%*\%,slong,acb-method}
\alias{+,ulong,missing-method}
\alias{+,slong,missing-method}
\alias{-,ulong,missing-method}
\alias{-,slong,missing-method}
\alias{Complex,ulong-method}
\alias{Complex,slong-method}
\alias{Math,ulong-method}
\alias{Math,slong-method}
\alias{Math2,ulong-method}
\alias{Math2,slong-method}
\alias{Ops,ANY,ulong-method}
\alias{Ops,ANY,slong-method}
\alias{Ops,ulong,ANY-method}
\alias{Ops,slong,ANY-method}
\alias{Ops,ulong,slong-method}
\alias{Ops,slong,slong-method}
\alias{Ops,ulong,ulong-method}
\alias{Ops,slong,ulong-method}
\alias{Ops,ulong,fmpz-method}
\alias{Ops,slong,fmpz-method}
\alias{Ops,ulong,fmpq-method}
\alias{Ops,slong,fmpq-method}
\alias{Ops,ulong,mag-method}
\alias{Ops,slong,mag-method}
\alias{Ops,ulong,arf-method}
\alias{Ops,slong,arf-method}
\alias{Ops,ulong,acf-method}
\alias{Ops,slong,acf-method}
\alias{Ops,ulong,arb-method}
\alias{Ops,slong,arb-method}
\alias{Ops,ulong,acb-method}
\alias{Ops,slong,acb-method}
\alias{Summary,ulong-method}
\alias{Summary,slong-method}
\alias{anyNA,ulong-method}
\alias{anyNA,slong-method}
\alias{as.vector,ulong-method}
\alias{as.vector,slong-method}
\alias{backsolve,ANY,ulong-method}
\alias{backsolve,ANY,slong-method}
\alias{backsolve,ulong,ANY-method}
\alias{backsolve,slong,ANY-method}
\alias{backsolve,ulong,slong-method}
\alias{backsolve,slong,slong-method}
\alias{backsolve,ulong,ulong-method}
\alias{backsolve,slong,ulong-method}
\alias{backsolve,ulong,fmpz-method}
\alias{backsolve,slong,fmpz-method}
\alias{backsolve,ulong,fmpq-method}
\alias{backsolve,slong,fmpq-method}
\alias{backsolve,ulong,mag-method}
\alias{backsolve,slong,mag-method}
\alias{backsolve,ulong,arf-method}
\alias{backsolve,slong,arf-method}
\alias{backsolve,ulong,acf-method}
\alias{backsolve,slong,acf-method}
\alias{backsolve,ulong,arb-method}
\alias{backsolve,slong,arb-method}
\alias{backsolve,ulong,acb-method}
\alias{backsolve,slong,acb-method}
\alias{chol,ulong-method}
\alias{chol,slong-method}
\alias{chol2inv,ulong-method}
\alias{chol2inv,slong-method}
\alias{coerce,ANY,ulong-method}
\alias{coerce,ANY,slong-method}
\alias{colMeans,ulong-method}
\alias{colMeans,slong-method}
\alias{colSums,ulong-method}
\alias{colSums,slong-method}
\alias{crossprod,ANY,ulong-method}
\alias{crossprod,ANY,slong-method}
\alias{crossprod,ulong,ANY-method}
\alias{crossprod,slong,ANY-method}
\alias{crossprod,ulong,slong-method}
\alias{crossprod,slong,slong-method}
\alias{crossprod,ulong,ulong-method}
\alias{crossprod,slong,ulong-method}
\alias{crossprod,ulong,fmpz-method}
\alias{crossprod,slong,fmpz-method}
\alias{crossprod,ulong,fmpq-method}
\alias{crossprod,slong,fmpq-method}
\alias{crossprod,ulong,mag-method}
\alias{crossprod,slong,mag-method}
\alias{crossprod,ulong,arf-method}
\alias{crossprod,slong,arf-method}
\alias{crossprod,ulong,acf-method}
\alias{crossprod,slong,acf-method}
\alias{crossprod,ulong,arb-method}
\alias{crossprod,slong,arb-method}
\alias{crossprod,ulong,acb-method}
\alias{crossprod,slong,acb-method}
\alias{det,ulong-method}
\alias{det,slong-method}
\alias{determinant,ulong-method}
\alias{determinant,slong-method}
\alias{is.finite,ulong-method}
\alias{is.finite,slong-method}
\alias{is.infinite,ulong-method}
\alias{is.infinite,slong-method}
\alias{is.na,ulong-method}
\alias{is.na,slong-method}
\alias{is.nan,ulong-method}
\alias{is.nan,slong-method}
\alias{is.unsorted,ulong-method}
\alias{is.unsorted,slong-method}
\alias{mean,ulong-method}
\alias{mean,slong-method}
\alias{rowMeans,ulong-method}
\alias{rowMeans,slong-method}
\alias{rowSums,ulong-method}
\alias{rowSums,slong-method}
\alias{solve,ANY,ulong-method}
\alias{solve,ANY,slong-method}
\alias{solve,ulong,ANY-method}
\alias{solve,slong,ANY-method}
\alias{solve,ulong,slong-method}
\alias{solve,slong,slong-method}
\alias{solve,ulong,ulong-method}
\alias{solve,slong,ulong-method}
\alias{solve,ulong,fmpz-method}
\alias{solve,slong,fmpz-method}
\alias{solve,ulong,fmpq-method}
\alias{solve,slong,fmpq-method}
\alias{solve,ulong,mag-method}
\alias{solve,slong,mag-method}
\alias{solve,ulong,arf-method}
\alias{solve,slong,arf-method}
\alias{solve,ulong,acf-method}
\alias{solve,slong,acf-method}
\alias{solve,ulong,arb-method}
\alias{solve,slong,arb-method}
\alias{solve,ulong,acb-method}
\alias{solve,slong,acb-method}
\alias{tcrossprod,ANY,ulong-method}
\alias{tcrossprod,ANY,slong-method}
\alias{tcrossprod,ulong,ANY-method}
\alias{tcrossprod,slong,ANY-method}
\alias{tcrossprod,ulong,slong-method}
\alias{tcrossprod,slong,slong-method}
\alias{tcrossprod,ulong,ulong-method}
\alias{tcrossprod,slong,ulong-method}
\alias{tcrossprod,ulong,fmpz-method}
\alias{tcrossprod,slong,fmpz-method}
\alias{tcrossprod,ulong,fmpq-method}
\alias{tcrossprod,slong,fmpq-method}
\alias{tcrossprod,ulong,mag-method}
\alias{tcrossprod,slong,mag-method}
\alias{tcrossprod,ulong,arf-method}
\alias{tcrossprod,slong,arf-method}
\alias{tcrossprod,ulong,acf-method}
\alias{tcrossprod,slong,acf-method}
\alias{tcrossprod,ulong,arb-method}
\alias{tcrossprod,slong,arb-method}
\alias{tcrossprod,ulong,acb-method}
\alias{tcrossprod,slong,acb-method}
\docType{class}
\title{Fixed Precision Unsigned and Signed Integers}
\description{
  Classes \code{ulong} and \code{slong} extend virtual class
  \code{\linkS4class{flint}}.  They represent vectors of fixed precision
  unsigned and signed integers, respectively.  The integer size is 32 or
  64 bits, depending on the ABI; see \code{\link{flintABI}}.  There is
  no representation for \R{}'s missing value \code{\link{NA_integer_}}.
}
\usage{
## Class generator functions

ulong(x = 0L, length = 0L, names = NULL)
slong(x = 0L, length = 0L, names = NULL)

ulong.array(x = 0L, dim = length(x), dimnames = NULL)
slong.array(x = 0L, dim = length(x), dimnames = NULL)
}
\arguments{
  \item{x}{
    an atomic or \code{\linkS4class{flint}} vector containing data for
    conversion to \code{ulong} or \code{slong}.}
  \item{length}{
    a numeric vector of length one giving the length of the return
    value.  If that exceeds the length of \code{x}, then \code{x} is
    recycled.  Non-integer values are rounded in the direction of zero.}
  \item{names}{
    the \code{names} slot of the return value, either \code{NULL} or a
    character vector of equal length.  Non-character \code{names} are
    coerced to character.}
  \item{dim}{
    the \code{dim} slot of the return value, an integer vector of
    nonzero length.  If the product exceeds the length of \code{x}, then
    \code{x} is recycled.  Non-integer numeric \code{dim} are coerced to
    integer.}
  \item{dimnames}{
    the \code{dimnames} slot of the return value, either \code{NULL} or
    a list of length equal to the length of \code{dim}.  The components
    are either \code{NULL} or character vectors of length given by
    \code{dim}.  Non-character vector components of \code{dimnames} are
    coerced to character.}
}
\value{
  A \code{ulong} or \code{slong} vector, possibly an array; see
  \sQuote{Details}.
}
\details{
  The class generator functions have four distinct usages:
  \preformatted{ulong()
ulong(length=)
ulong(x)
ulong(x, length=)

slong()
slong(length=)
slong(x)
slong(x, length=)}
  The first usage generates an empty vector.  The second usage generates
  a zero vector of the indicated length.  The third usage converts
  \code{x}, preserving dimensions, dimension names, and names.  The
  fourth usage converts \code{x}, recycling its elements to the
  indicated length and discarding its dimensions, dimension names, and
  names.  Attempts to recycle \code{x} of length zero to nonzero length
  are an error.

  Usage of \code{ulong.array} and \code{slong.array} is modelled after
  \code{\link{array}}.
}
\section{Conversion}{
  Real numbers and real parts of complex numbers are rounded in the
  direction of 0.  Imaginary parts of complex numbers are discarded.

  Character strings are converted using function \code{mpz_set_str} from
  the \acronym{GNU} \acronym{MP} library with argument \code{base} set
  to 0; see \url{https://gmplib.org/manual/Assigning-Integers}.

  An error is signaled if elements of \code{x} are not in the range of
  the \proglang{C} type, in particular if elements of \code{x} are
  \code{NaN}, \code{-Inf}, or \code{Inf}.  The range is
  \eqn{(-1, 2^{n})} for \code{ulong} and \eqn{(-2^{n-1}-1, 2^{n-1})} for
  \code{slong}, where \eqn{n} is the value of \code{\link{flintABI}()}.
}
\section{Slots}{
  \describe{
    \item{\code{.xData}, \code{dim}, \code{dimnames}, \code{names}}{
      inherited from virtual class \code{\linkS4class{flint}}.}
  }
}
\section{Methods}{
  \describe{
    \item{\code{!}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      equivalent to (but faster than) \code{x == 0}.}
    \item{\code{\%*\%}, \code{crossprod}, \code{tcrossprod}}{
      \code{signature(x = "ulong", y = "ulong")}:\cr
      \code{signature(x = "slong", y = "slong")}:\cr
      \code{signature(x = "ulong", y = "ANY")}:\cr
      \code{signature(x = "slong", y = "ANY")}:\cr
      \code{signature(x = "ANY", y = "ulong")}:\cr
      \code{signature(x = "ANY", y = "slong")}:\cr
      matrix products.  The \dQuote{other} operand must be atomic or
      inherit from virtual class \code{\linkS4class{flint}}.
      \code{crossprod} and \code{tcrossprod} behave as if \code{y = x}
      when \code{y} is missing or \code{NULL}.  Operands are promoted as
      necessary and must be conformable (have compatible dimensions).
      Non-array operands of length \code{k} are handled as 1-by-\code{k}
      or \code{k}-by-1 matrices depending on the call.}
    \item{\code{+}}{
      \code{signature(e1 = "ulong", e2 = "missing")}:\cr
      \code{signature(e1 = "slong", e2 = "missing")}:\cr
      returns a copy of the argument.}
    \item{\code{-}}{
      \code{signature(e1 = "ulong", e2 = "missing")}:\cr
      \code{signature(e1 = "slong", e2 = "missing")}:\cr
      returns the negation of the argument.}
    \item{\code{Complex}}{
      \code{signature(z = "ulong")}:\cr
      \code{signature(z = "slong")}:\cr
      mathematical functions of one argument; see
      \code{\link[methods]{S4groupGeneric}}.  Member functions requiring
      promotion to a floating-point type may not be implemented.}
    \item{\code{Math}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      mathematical functions of one argument; see
      \code{\link[methods]{S4groupGeneric}}.  Member functions requiring
      promotion to a floating-point type may not be implemented.}
    \item{\code{Math2}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      decimal rounding according to a second argument \code{digits}; see
      \code{\link[methods]{S4groupGeneric}}.  There are just two member
      member functions: \code{\link{round}}, \code{\link{signif}}.}
    \item{\code{Ops}}{
      \code{signature(e1 = "ulong", e2 = "ulong")}:\cr
      \code{signature(e1 = "slong", e2 = "slong")}:\cr
      \code{signature(e1 = "ulong", e2 = "ANY")}:\cr
      \code{signature(e1 = "slong", e2 = "ANY")}:\cr
      \code{signature(e1 = "ANY", e2 = "ulong")}:\cr
      \code{signature(e1 = "ANY", e2 = "slong")}:\cr
      binary arithmetic, comparison, and logical operators; see
      \code{\link[methods]{S4groupGeneric}}.  The \dQuote{other} operand
      must be atomic or inherit from virtual class
      \code{\linkS4class{flint}}.  Operands are promoted as necessary.
      Array operands must be conformable (have identical dimensions).
      Non-array operands are recycled.}
    \item{\code{Summary}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      univariate summary statistics; see
      \code{\link[methods]{S4groupGeneric}}.  The return value is a
      logical vector of length 1 (\code{any}, \code{all}) or a
      \code{ulong}, \code{slong}, or \code{\linkS4class{fmpz}} vector of
      length 1 or 2 (\code{sum}, \code{prod}, \code{min}, \code{max},
      \code{range}).}
    \item{\code{anyNA}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns \code{FALSE}, as \code{ulong} and \code{slong} have no
      representation for \code{NaN}.}
    \item{\code{as.vector}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns \code{as.vector(y, mode)}, where \code{y} is a double
      vector containing the result of converting each element of
      \code{x} to the range of double, rounding if the value is not
      exactly representable in double precision.  The rounding mode is
      to the nearest representable number in the direction of zero.
      Coercion to types \code{"character"}, \code{"symbol"} (synonym
      \code{"name"}), \code{"pairlist"}, \code{"list"}, and
      \code{"expression"}, which are not \dQuote{number-like}, is
      handled specially.  See also \code{\link{asVector}}.}
    \item{\code{backsolve}}{
      \code{signature(r = "ulong", x = "ulong")}:\cr
      \code{signature(r = "slong", x = "slong")}:\cr
      \code{signature(r = "ulong", x = "ANY")}:\cr
      \code{signature(r = "slong", x = "ANY")}:\cr
      \code{signature(r = "ANY", x = "ulong")}:\cr
      \code{signature(r = "ANY", x = "slong")}:\cr
      solution of the triangular system \code{op2(op1(r)) \%*\% y = x},
      where \code{op1=ifelse(upper.tri, triu, tril)} and
      \code{op2=ifelse(transpose, t, identity)} and \code{upper.tri} and
      \code{transpose} are optional logical arguments with default
      values \code{TRUE} and \code{FALSE}, respectively.  The
      \dQuote{other} operand must be atomic or inherit from virtual
      class \code{\linkS4class{flint}}.  If \code{x} is missing, then
      the return value is the inverse of \code{op2(op1(r))}, as if
      \code{x} were the identity matrix.  Operands are promoted as
      necessary and must be conformable (have compatible dimensions).
      Non-array \code{x} are handled as \code{length(x)}-by-1 matrices.
      If \code{r} and (if not missing) \code{x} are both formally
      rational, then the solution is exact and the return value is an
      \code{\linkS4class{fmpq}} matrix.}
    \item{\code{chol}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      coerces \code{x} to class \code{\linkS4class{arf}} and
      dispatches.}
    \item{\code{chol2inv}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns the inverse of the positive definite matrix whose upper
      triangular Cholesky factor is the upper triangular part of
      \code{x}.  The return value is the exact inverse, being computed
      as \code{tcrossprod(backsolve(x))}.}
    \item{\code{coerce}}{
      \code{signature(from = "ANY", to = "ulong")}:\cr
      \code{signature(from = "ANY", to = "slong")}:\cr
      returns the value of \code{ulong(from)} or \code{slong(from)}.}
    \item{\code{colSums}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns a \code{ulong} or (in case of overflow)
      \code{\linkS4class{fmpz}} vector or array containing the column
      sums of \code{x}, defined as sums over dimensions \code{1:dims}.}
    \item{\code{colMeans}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns an \code{\linkS4class{fmpq}} vector or array containing
      the column means of \code{x}, defined as means over dimensions
      \code{1:dims}.}
    \item{\code{det}, \code{determinant}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      coerces \code{x} to class \code{\linkS4class{fmpz}} and
      dispatches.}
    \item{\code{format}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns a character vector suitable for printing.  Optional
      arguments control the output; see \code{\link{format-methods}}.}
    \item{\code{is.finite}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns a logical vector whose elements are all \code{TRUE}, as
      \code{ulong} and \code{slong} have no representation for
      \code{NaN}, \code{-Inf}, and \code{Inf}.}
    \item{\code{is.infinite}, \code{is.na}, \code{is.nan}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns a logical vector whose elements are all \code{FALSE}, as
      \code{ulong} and \code{slong} have no representation for
      \code{NaN}, \code{-Inf}, and \code{Inf}.}
    \item{\code{is.unsorted}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns a logical indicating if \code{x} is not sorted in
      nondecreasing order (increasing order if optional argument
      \code{strictly} is set to \code{TRUE}).}
    \item{\code{mean}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns the arithmetic mean.  An error is signaled if the argument
      length is 0, because the return type is \code{\linkS4class{fmpq}}
      which cannot represent the result of division by 0.}
    \item{\code{rowSums}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns a \code{ulong} or (in case of overflow)
      \code{\linkS4class{fmpz}} vector or array containing the row sums
      of \code{x}, defined as sums over dimensions
      \code{(dims+1):length(dim(x))}.}
    \item{\code{rowMeans}}{
      \code{signature(x = "ulong")}:\cr
      \code{signature(x = "slong")}:\cr
      returns an \code{\linkS4class{fmpq}} vector or array containing
      the row means of \code{x}, defined as means over dimensions
      \code{(dims+1):length(dim(x))}.}
    \item{\code{solve}}{
      \code{signature(a = "ulong", b = "ulong")}:\cr
      \code{signature(a = "slong", b = "slong")}:\cr
      \code{signature(a = "ulong", b = "ANY")}:\cr
      \code{signature(a = "slong", b = "ANY")}:\cr
      \code{signature(a = "ANY", b = "ulong")}:\cr
      \code{signature(a = "ANY", b = "slong")}:\cr
      solution of the general system \code{a \%*\% x = b}.  The
      \dQuote{other} operand must be atomic or inherit from virtual
      class \code{\linkS4class{flint}}.  If \code{b} is missing, then
      the return value is the inverse of \code{a}, as if \code{b} were
      the identity matrix.  Operands are promoted as necessary and must
      be conformable (have compatible dimensions).  Non-array \code{b}
      are handled as \code{length(b)}-by-1 matrices.  If \code{a} and
      (if not missing) \code{b} are both formally rational, then the
      solution is exact and the return value is an
      \code{\linkS4class{fmpq}} matrix.}
  }
}
\seealso{
  Virtual class \code{\linkS4class{flint}}.
}
\references{
  The \acronym{FLINT} documentation of the underlying \proglang{C}
  types: \url{https://flintlib.org/doc/flint.html}
}
\examples{
showClass("ulong")
showClass("slong")
showMethods(classes = c("ulong", "slong"))
}
\keyword{classes}
