% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{inprod_mfd_diag}
\alias{inprod_mfd_diag}
\title{Inner product of two multivariate functional data objects,
for each observation}
\usage{
inprod_mfd_diag(mfdobj1, mfdobj2 = NULL)
}
\arguments{
\item{mfdobj1}{A multivariate functional data object of class \code{mfd}.}

\item{mfdobj2}{A multivariate functional data object of class \code{mfd},
with the same number of functional variables and observations
as \code{mfdobj1}.
If NULL, then \code{mfdobj2=mfdobj1}. Default is NULL.}
}
\value{
It calculates the inner product of two
multivariate functional data objects.
The main function \code{inprod} of the package \code{fda}
calculates inner products among
all possible couples of observations.
This means that, if \code{mfdobj1} has \code{n1} observations
and \code{mfdobj2} has \code{n2} observations,
then for each variable \code{n1 X n2} inner products are calculated.
However, often one is interested only in calculating
the \code{n} inner products
between the \code{n} observations of \code{mfdobj1} and
the corresponding \code{n}
observations of \code{mfdobj2}. This function provides
this "diagonal" inner products only,
saving a lot of computation with respect to using
\code{fda::inprod} and then extracting the
diagonal elements.
Note that the code of this function calls a modified version
of \code{fda::inprod()}.
}
\description{
Inner product of two multivariate functional data objects,
for each observation
}
\examples{
mfdobj <- data_sim_mfd()
inprod_mfd_diag(mfdobj)

}
