% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbp2d_cpp_rd.r
\docType{class}
\name{gbp2q}
\alias{Rcpp_gbp2q}
\alias{Rcpp_gbp2q-class}
\alias{gbp2q}
\title{gbp2q}
\format{An object of class \code{C++Class} of length 1.}
\usage{
gbp2q
}
\description{
generalized bin packing problem in 2 dimension, a.k.a rectangle fill.
}
\details{
gbp2d init a profit vector p, a length vector l, a depth vector d,
  a length constraint ml, and a depth constraint md on l x d rectangle
  with geometry intepretation.

 gbp2d solver would solve

   maximize   sum_{j=1}^{n} p_{j} k_{j}

   subject to fit (l_{j}, d_{j}) at coordinate (x_{j}, y_{j})
              such that no overlap in ml x md, j = 1, ...., n

 and instantiate a gbp2d object with a x-axis coordinate vector x, a y-axis coordinate vector y,
  a selection vector k, and an objective o.

 gbp2q solver would also select the most preferred often smallest m from a list of m(l, d) after
  determine all or the higest volume set of ld can fit into one m(l, d).

 a gbp2q class instance has 7 fields:

  - p: profit of it fit into bn <vector>

       created via cluster max(l, d) and min(l, d) via gbp2d_solver_dpp_prep_create_p()

  - it: it position and scale <matrix>

    - x, y it position in the bin <numeric>

    - l, d it scale along x and y <numeric>

  - bn: bn scale <matrix>

    - l, d bn scale along x and y <numeric>

      matrix of 2 rows and each column is a single bn

    should make sure bn list are sorted via volume
     so that the first col is the most prefered smallest bn, and also
     the last col is the least prefered largest and often dominant bn

    should make sure no X in front of Y if bnX dominant bnY,
     bnX dominant bnY if all(X(l, d) > Y(l, d)) and should always prefer Y.

    should make sure bn such that l >= d or vice versa.

  - k: selection indicator 0, 1 on it <vector>

  - f: selection indicator 0, 1, 2, 3 on bn <vector>

       f in result should have no 0 and only one of 1

  - o: objective achivement volumn fit in over volumn overall <numeric>

  - ok: a quick indicator of all it fit into bn? <bool>
}
\seealso{
Other gbp2q: \code{\link{gbp2d_solver_dpp_filt}},
  \code{\link{gbp2q_checkr}}
}
\keyword{datasets}

