% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spd_lesh.R
\name{spd_lesh}
\alias{spd_lesh}
\title{shap power of determinants}
\usage{
spd_lesh(formula, data, cores = 1, ...)
}
\arguments{
\item{formula}{A formula of calculate shap power of determinants.}

\item{data}{A data.frame or tibble of observation data.}

\item{cores}{(optional) Positive integer (default is 1). When cores are greater than 1, use
multi-core parallel computing.}

\item{...}{(optional) Other arguments passed to \code{rpart_disc()}.}
}
\value{
A tibble with variable and its corresponding \eqn{SPD} value.
}
\description{
Function for calculate shap power of determinants \eqn{SPD}.
}
\details{
The power of shap power of determinants formula is

\eqn{\theta_{x_j} \left( S \right) = \sum\limits_{s \in M \setminus \{x_j\}} \frac{|S|! \left(|M| - |S| - 1\right)!}{|M|!}\left(v \left(S \cup \left\{x_j\right\} \right) - v\left(S\right)\right)}.

shap power of determinants (SPD) is the contribution of variable \eqn{x_j} to the power of determinants.
}
\note{
The shap power of determinants (SPD) requires at least \eqn{2^n-1} calculations when has \eqn{n} explanatory variables.
When there are more than 10 explanatory variables, carefully consider the computational burden of this model.
When there are a large number of explanatory variables, the data dimensionality reduction method can be used
to ensure the trade-off between analysis results and calculation speed.
}
\examples{
data('ndvi')
g = spd_lesh(NDVIchange ~ ., data = ndvi)
g

}
\references{
Li, Y., Luo, P., Song, Y., Zhang, L., Qu, Y., & Hou, Z. (2023). A locally explained heterogeneity model for
examining wetland disparity. International Journal of Digital Earth, 16(2), 4533–4552.
https://doi.org/10.1080/17538947.2023.2271883
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
