% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna_tools.R
\name{vector_to_string}
\alias{vector_to_string}
\title{Join a vector into a comma-separated string (generic \code{ggDNAvis} helper)}
\usage{
vector_to_string(vector, sep = ",")
}
\arguments{
\item{vector}{\code{vector}. A vector (e.g. \code{c(1,2,3)}) to convert to a string.}

\item{sep}{\code{character}. The character used to separate values in the string. Defaults to \code{","}. \emph{Do not set to anything that might occur within one of the values}.}
}
\value{
\code{character}. The same vector but as a comma-separated string (e.g. \code{"1,2,3"}).
}
\description{
Takes a vector and condenses it into a single string by joining items with \code{","}.
Reversed by \code{\link[=string_to_vector]{string_to_vector()}}.
}
\examples{
vector_to_string(c(1, 2, 3, 4))
vector_to_string(c("These", "are", "some", "words"))
vector_to_string(3:5, sep = ";")

}
