% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brain_join.R
\name{brain_join}
\alias{brain_join}
\title{Join atlas and data}
\usage{
brain_join(data, atlas, by = NULL)
}
\arguments{
\item{data}{data.frame}

\item{atlas}{atlas data}

\item{by}{optional character vector of column to join by}
}
\value{
either an sf-object (if brain atlas) or a tibble (if ggseg-atlas)
        with merged atlas and data
}
\description{
Joins data frame with a brain-atlas
object.
}
\examples{
someData = data.frame(
    region = c("transverse temporal", "insula",
                "precentral","superior parietal"),
    p = sample(seq(0,.5,.001), 4),
    stringsAsFactors = FALSE)

brain_join(someData, dk)
brain_join(someData, dk, "region")

}
