% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_napp.R
\name{glm.napp}
\alias{glm.napp}
\title{Posterior of normalized asymptotic power prior (NAPP)}
\usage{
glm.napp(
  formula,
  family,
  data.list,
  offset.list = NULL,
  a0.shape1 = 1,
  a0.shape2 = 1,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates.}

\item{family}{an object of class \code{family}. See \code{\link[stats:family]{?stats::family}}.}

\item{data.list}{a list of \code{data.frame}s. The first element in the list is the current data, and the rest
are the historical datasets.}

\item{offset.list}{a list of vectors giving the offsets for each data. The length of \code{offset.list} is equal to
the length of \code{data.list}. The length of each element of \code{offset.list} is equal to the number
of rows in the corresponding element of \code{data.list}. Defaults to a list of vectors of 0s.}

\item{a0.shape1}{first shape parameter for the i.i.d. beta prior on a0 vector. When \code{a0.shape1 == 1} and
\code{a0.shape2 == 1}, a uniform prior is used.}

\item{a0.shape2}{second shape parameter for the i.i.d. beta prior on a0 vector. When \code{a0.shape1 == 1} and
\code{a0.shape2 == 1}, a uniform prior is used.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g., \code{seed}, \code{refresh}, \code{init}).}
}
\value{
The function returns an object of class \code{draws_df} giving posterior samples, with an attribute called 'data' which includes
the list of variables specified in the data block of the Stan program.
}
\description{
Sample from the posterior distribution of a GLM using the normalized asymptotic power prior (NAPP) by
Ibrahim et al. (2015) \url{doi:10.1002/sim.6728}.
}
\details{
The normalized asymptotic power prior (NAPP) assumes that the regression coefficients and logarithm of the
dispersion parameter are a multivariate normal distribution with mean equal to the maximum likelihood
estimate of the historical data and covariance matrix equal to \eqn{a_0^{-1}} multiplied by the inverse Fisher
information matrix of the historical data, where \eqn{a_0} is the power prior parameter (treated as random).
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  data(actg019)
  data(actg036)
  ## take subset for speed purposes
  actg019 = actg019[1:100, ]
  actg036 = actg036[1:50, ]
  data_list = list(currdata = actg019, histdata = actg036)
  glm.napp(
    formula = cd4 ~ treatment + age + race,
    family = poisson('log'),
    data.list = data_list,
    chains = 1, iter_warmup = 500, iter_sampling = 1000
  )
}
}
\references{
Ibrahim, J. G., Chen, M., Gwon, Y., and Chen, F. (2015). The power prior: Theory and applications. Statistics in Medicine, 34(28), 3724–3749.
}
