## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(healthmotionR)
library(dplyr)
library(ggplot2)

## ----bodymetrics-plot, fig.width=6, fig.height=4.5, out.width="90%"-----------

# Process dataset
body_metrics_df %>%
  mutate(gender = ifelse(gender == 1, "Male", "Female")) %>%
  ggplot(aes(x = gender, y = temperature, fill = gender)) +
  geom_boxplot(alpha = 0.6) +
  geom_jitter(width = 0.2, alpha = 0.5, color = "black") +
  labs(
    title = "Body Temperature Distribution by Gender",
    x = "Gender",
    y = "Temperature (°C)"
  ) +
  theme_minimal() +
  theme(legend.position = "none")


