% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver-api.R
\name{hi_solver_add_cols}
\alias{hi_solver_add_cols}
\title{Add Variables to Model}
\usage{
hi_solver_add_cols(solver, costs, lower, upper, start, index, value)
}
\arguments{
\item{solver}{An object of class "highs_solver".}

\item{costs}{A numeric vector of objective coefficients.}

\item{lower}{A numeric vector giving the lower bounds of the new variables.}

\item{upper}{A numeric vector giving the upper bounds of the new variables.}

\item{start}{An integer vector of starting positions in the sparse matrix.}

\item{index}{An integer vector of row indices.}

\item{value}{A numeric vector of coefficient values.}
}
\value{
The solver instance with new variables added.
}
\description{
This function adds new variables (columns) to the optimization model.
}
\examples{
solver <- example_solver()
hi_solver_add_cols(solver, c(1), c(0), c(10), c(0, 1), c(0), c(2))

}
