% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{image_otsu}
\alias{image_otsu}
\title{Image segmentation using Otsu}
\usage{
image_otsu(x, threshold = 0)
}
\arguments{
\item{x}{an object of class magick-image or a greyscale matrix of image pixel values in the 0-255 range}

\item{threshold}{integer value in range of 0-255. To override the threshold. Defaults to 0 indicating not to override the threshold.}
}
\value{
In case \code{x} is a matrix, a list with elements x (containing the thresholded image) and threshold is returned \cr
In case \code{x} is a \code{magick-image}, the thresholded \code{magick-image} is returned alongside
which also now has an attribute called threshold with the exact Otsu threshold value
}
\description{
An implementation of the Otsu's image segmentation algorithm explained at \url{https://doi.org/10.5201/ipol.2016.158}.
}
\examples{
library(magick)
path <- system.file(package="image.Otsu", "extdata", "coins.jpeg")
x    <- image_read(path)
x
img  <- image_otsu(x)
img
attr(img, "threshold")
img  <- image_otsu(x, threshold = 180)
img

img  <- image_data(x, channels = "gray")
img  <- as.integer(img, transpose = TRUE)
img  <- img[, , 1]
img  <- image_otsu(img)
str(img)
}
