% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareData.R
\name{PrepareData}
\alias{PrepareData}
\title{PrepareData}
\usage{
PrepareData(..., from, to, diseaseID, format = "single", sep)
}
\arguments{
\item{...}{data frame, containing interaction information.}

\item{from}{A charactor vector, containing "drug", "herb", "compound", or "target".}

\item{to}{A character vector, containing "drug", "herb", "compound", or "target".}

\item{diseaseID}{Charactor vector, diseaseID}

\item{format}{one of "single" or "basket".}

\item{sep}{Separator.}
}
\value{
A igraph object.
}
\description{
Prepare input format.
}
\examples{
data(drugdemo)
drug_herb <- PrepareData(drugdemo$drug_herb, from = "drug", to="herb")
herb_compound <- PrepareData(drugdemo$herb_compound, from = "herb", to="compound")
compound_target <- PrepareData(drugdemo$compound_target, from = "compound", to="target")
disease <- PrepareData(drugdemo$disease, diseaseID = "disease",from = "target", to="target")
}
\author{
Yuanlong Hu
}
